% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.show.season.R
\name{trakt.show.season}
\alias{trakt.show.season}
\title{Get a season of a show}
\usage{
trakt.show.season(target, seasons = 1, extended = "full,images")
}
\arguments{
\item{target}{The \code{slug} of the show requested}

\item{seasons}{The season to get. Defaults to 1. Use 0 for special episodes.}

\item{extended}{Defaults to \code{full,images} to get season posters. Can be
\code{min}, \code{images}, \code{full}, \code{full,images}}
}
\value{
A \code{data.frame} containing all of a season's episodes
}
\description{
\code{trakt.show.season} pulls a season's full data.
Similar to \link{trakt.getSeasons}, but this function returns full data for
a single season, i.e. all the episodes of the season.
See \href{http://docs.trakt.apiary.io/#introduction/extended-info}{the API docs} for possible values of
\code{extended} to customize output amount.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/seasons/season/get-single-season-for-a-show}{the trakt API docs for further info}.
If you want to quickly gather data of multiple seasons, see \link[tRakt]{trakt.getEpisodeData}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.seasons <- trakt.show.season("breaking-bad", 1)
}
}
\seealso{
Other show: \code{\link{trakt.getEpisodeData}};
  \code{\link{trakt.getFullShowData}};
  \code{\link{trakt.getSeasons}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.related}};
  \code{\link{trakt.show.stats}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.trending}}
}

