\name{LDMap}
\Rdversion{1.1}
\alias{LDMap}

\title{
LD Heatmap
}
\description{
Visualization of pairwise Linkage Disequilibrium (LD) estimates generated by function \code{pairwiseLD} in a LD heatmap for each chromosome using the \code{LDheatmap} package (Shin et al, 2006) .
}
\usage{
LDMap(LDmat,gpData,chr=NULL,file=NULL,fileFormat="pdf",onefile=TRUE,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{LDmat}{
Object of class \code{LDmat} generated by function \code{pairwiseLD} and argument \code{type="matrix"}
}
  \item{gpData}{
Object of class \code{gpData} that was used in \code{pairwiseLD}
}
  \item{chr}{
\code{numeric}. Return value is a plot for each chromosome in \code{chr}.
}  
  \item{file}{
Optionally a path to a file where the plot is saved to
}
  \item{fileFormat}{
\code{character}. At the moment two file formats are supported: pdf and png. Default is \code{"pdf"}.
}
  \item{onefile}{
\code{logical}. If \code{fileFormat = "pdf"} you can decide, if you like to have all graphics 
in one file or in multiple files. } 
  \item{\dots}{
Further arguments that could be passed to function \code{LDheatmap}
}
}

\details{
Note: If you have an \code{LDmat}-object with more than one chromosome and you like to 
plot all chromosomes, you need to put an empty line for each chromosome in your script after 
the LDMap function! } 

\references{
Shin JH, Blay S, McNeney B, Graham J (2006). LDheatmap: An R Function for Graphical
Display of Pairwise Linkage Disequilibria Between Single Nucleotide Polymorphisms. 
Journal of Statistical Software, 16, Code Snippet 3. URL http://stat-db.stat.sfu.ca:
8080/statgen/research/LDheatmap/.
}
\author{
 Hans-Juergen Auinger, Theresa Albrecht and Valentin Wimmer
}
\seealso{
\code{\link{pairwiseLD}}, \code{\link[LDheatmap]{LDheatmap}}, \code{\link{LDDist}}
}
\examples{
\dontrun{
data(maize)
maizeC <- codeGeno(maize)

# LD for chr 1
maizeLD <- pairwiseLD(maizeC,chr=1,type="matrix")
LDMap(maizeLD,maizeC)
}
}
\keyword{hplot}
