\name{LDMap}
\Rdversion{1.1}
\alias{LDMap}

\title{
LD Heatmap
}
\description{
Visualization of pairwise Linkage Disequilibrium (LD) estimates generated by function \code{pairwiseLD} in a LD heatmap for each chromosome using the \code{LDheatmap} package (Shin et al, 2006) .
}
\usage{
LDMap(LDmat,gpData,chr=NULL,file=NULL,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{LDmat}{
Object of class \code{LDmat} generated by function \code{pairwiseLD} and argument \code{type="matrix"}
}
  \item{gpData}{
Object of class \code{gpData} that was used in \code{pairwiseLD}
}
  \item{chr}{
\code{numeric}. Return value is a plot for each chromosome in \code{chr}.
}  
  \item{file}{
Optionally a path to a file where plot is saved as \code{pdf}
}
  \item{\dots}{
Further arguments that could be passed to function \code{LDheatmap}
}
}

\references{
Shin JH, Blay S, McNeney B, Graham J (2006). LDheatmap: An R Function for Graphical
Display of Pairwise Linkage Disequilibria Between Single Nucleotide Polymorphisms. 
Journal of Statistical Software, 16, Code Snippet 3. URL http://stat-db.stat.sfu.ca:
8080/statgen/research/LDheatmap/.
}
\seealso{
\code{\link{pairwiseLD}}, \code{\link[LDheatmap]{LDheatmap}}, \code{\link{LDDist}}
}
\examples{
\dontrun{
data(maize)
maizeC <- codeGeno(maize)

# LD for chr 1
maizeLD <- pairwiseLD(maizeC,chr=1,type="matrix")
LDMap(maizeLD,maizeC)
}
}
\keyword{hplot}
