/*
 * Decompiled with CFR 0.152.
 */
package ibd;

import dag.Dag;
import haplotype.HapPairs;
import sample.DuoBaumLevel;
import sample.DuoNodes;
import sample.HapBaumLevel;
import sample.HapNodes;
import sample.SingleBaumLevel;
import sample.SingleNodes;
import vcf.GL;
import vcf.HbdAL;

public class IbdBaum {
    private static final double log_e_10 = Math.log(10.0);
    private final Dag dag;
    private final GL gl;
    private final int nMarkers;
    private final SingleNodes fwdNodesA;
    private final SingleNodes fwdNodesB;
    private final HapNodes fwdNodesHbd;
    private final DuoNodes fwdNodesIbd;
    private final SingleBaumLevel scratchSingleLevel;
    private final HapBaumLevel scratchHapLevel;
    private final DuoBaumLevel scratchDuoLevel;

    public IbdBaum(Dag dag, GL gL) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        this.dag = dag;
        this.gl = gL;
        this.nMarkers = dag.nLevels();
        this.fwdNodesHbd = new HapNodes();
        this.fwdNodesA = new SingleNodes();
        this.fwdNodesB = new SingleNodes();
        this.fwdNodesIbd = new DuoNodes();
        this.scratchSingleLevel = new SingleBaumLevel(dag, gL);
        this.scratchHapLevel = new HapBaumLevel(dag, new HbdAL(gL));
        this.scratchDuoLevel = new DuoBaumLevel(dag, gL);
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public double hbdLod(int n, int n2, int n3) {
        IbdBaum.checkStartAndEnd(n2, n3, this.nMarkers);
        if (n2 == n3) {
            return 0.0;
        }
        IbdBaum.setInitialNodes(this.dag, n2, this.fwdNodesHbd);
        IbdBaum.setInitialNodes(this.dag, n2, this.fwdNodesA);
        double d = IbdBaum.logLikelihood(this.fwdNodesHbd, this.scratchHapLevel, n, n2, n3);
        double d2 = IbdBaum.logLikelihood(this.fwdNodesA, this.scratchSingleLevel, n, n2, n3);
        return IbdBaum.lod(d - d2);
    }

    public double ibdLod(int n, int n2, int n3, int n4) {
        IbdBaum.checkStartAndEnd(n3, n4, this.nMarkers);
        if (n3 == n4) {
            return 0.0;
        }
        IbdBaum.setInitialNodes(this.dag, n3, this.fwdNodesA);
        IbdBaum.setInitialNodes(this.dag, n3, this.fwdNodesB);
        IbdBaum.setInitialNodes(this.dag, n3, this.fwdNodesIbd);
        double d = 0.0;
        d += IbdBaum.logLikelihood(this.fwdNodesA, this.scratchSingleLevel, n, n3, n4);
        double d2 = IbdBaum.logLikelihood(this.fwdNodesIbd, this.scratchDuoLevel, n, n2, n3, n4);
        return IbdBaum.lod(d2 - (d += IbdBaum.logLikelihood(this.fwdNodesB, this.scratchSingleLevel, n2, n3, n4)));
    }

    private static void checkStartAndEnd(int n, int n2, int n3) {
        if (n < 0 || n > n2 || n2 > n3) {
            String string = "start=" + n + " end=" + n2 + " nMarkers=" + n3;
            throw new IllegalArgumentException(string);
        }
    }

    private static void setInitialNodes(Dag dag, int n, HapNodes hapNodes) {
        hapNodes.clear();
        int n2 = dag.nParentNodes(n);
        for (int i = 0; i < n2; ++i) {
            float f = dag.parentProb(n, i);
            hapNodes.sumUpdate(i, f);
        }
    }

    private static void setInitialNodes(Dag dag, int n, SingleNodes singleNodes) {
        singleNodes.clear();
        int n2 = dag.nParentNodes(n);
        for (int i = 0; i < n2; ++i) {
            float f = dag.parentProb(n, i);
            for (int j = 0; j < n2; ++j) {
                float f2 = dag.parentProb(n, j);
                singleNodes.sumUpdate(i, j, f * f2);
            }
        }
    }

    private static void setInitialNodes(Dag dag, int n, DuoNodes duoNodes) {
        duoNodes.clear();
        int n2 = dag.nParentNodes(n);
        for (int i = 0; i < n2; ++i) {
            float f = dag.parentProb(n, i);
            for (int j = 0; j < n2; ++j) {
                float f2 = dag.parentProb(n, j);
                for (int k = 0; k < n2; ++k) {
                    float f3 = dag.parentProb(n, k);
                    duoNodes.sumUpdate(i, j, k, f * f2 * f3);
                }
            }
        }
    }

    private static double logLikelihood(HapNodes hapNodes, HapBaumLevel hapBaumLevel, int n, int n2, int n3) {
        int n4 = 2 * n;
        double d = 0.0;
        for (int i = n2; i < n3; ++i) {
            hapBaumLevel.setForwardValues(hapNodes, i, n4);
            d += Math.log(hapBaumLevel.forwardValuesSum());
        }
        return d;
    }

    private static double logLikelihood(SingleNodes singleNodes, SingleBaumLevel singleBaumLevel, int n, int n2, int n3) {
        double d = 0.0;
        for (int i = n2; i < n3; ++i) {
            singleBaumLevel.setForwardValues(singleNodes, i, n);
            d += Math.log(singleBaumLevel.forwardValuesSum());
        }
        return d;
    }

    private static double logLikelihood(DuoNodes duoNodes, DuoBaumLevel duoBaumLevel, int n, int n2, int n3, int n4) {
        double d = 0.0;
        for (int i = n3; i < n4; ++i) {
            duoBaumLevel.setForwardValues(duoNodes, i, n, n2);
            d += Math.log(duoBaumLevel.forwardValuesSum());
        }
        return d;
    }

    private static double lod(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return d / log_e_10;
    }

    public static double freqLod(int n, int n2, int n3, HapPairs hapPairs, Dag dag) {
        double d = 1.0E-100;
        IbdBaum.checkStartAndEnd(n2, n3, dag.nLevels());
        double d2 = 0.0;
        int n4 = dag.nParentNodes(n2);
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6 = i;
            double d3 = dag.parentProb(n2, i);
            for (int j = n2; j < n3 && d3 > 0.0; d3 *= (double)dag.condEdgeProb(j, n5), ++j) {
                int n7 = hapPairs.allele(j, n);
                n5 = dag.outEdgeBySymbol(j, n6, n7);
                if (n5 == -1) {
                    d3 = 0.0;
                    break;
                }
                n6 = dag.childNode(j, n5);
            }
            d2 += d3;
        }
        if (d2 < d) {
            d2 = d;
        }
        return IbdBaum.lod(-Math.log(d2));
    }
}

