/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.SampleFileIterator;
import java.io.File;
import java.util.NoSuchElementException;
import vcf.Marker;
import vcf.VcfRecord;

public final class IntervalVcfIterator
implements SampleFileIterator<VcfRecord> {
    private final SampleFileIterator<VcfRecord> it;
    private final ChromInterval interval;
    private VcfRecord next;

    public IntervalVcfIterator(SampleFileIterator<VcfRecord> sampleFileIterator, ChromInterval chromInterval) {
        if (sampleFileIterator == null) {
            throw new IllegalArgumentException("it==null");
        }
        if (chromInterval == null) {
            throw new IllegalArgumentException("interval==null");
        }
        this.it = sampleFileIterator;
        this.interval = chromInterval;
        this.next = IntervalVcfIterator.readFirstRecord(sampleFileIterator, chromInterval);
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public Samples samples() {
        return this.it.samples();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public VcfRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        VcfRecord vcfRecord = this.next;
        this.next = IntervalVcfIterator.readNextRecord(this.it, this.interval);
        return vcfRecord;
    }

    private static VcfRecord readFirstRecord(SampleFileIterator<VcfRecord> sampleFileIterator, ChromInterval chromInterval) {
        VcfRecord vcfRecord = null;
        while (vcfRecord == null && sampleFileIterator.hasNext()) {
            VcfRecord vcfRecord2 = (VcfRecord)sampleFileIterator.next();
            if (!IntervalVcfIterator.inInterval(chromInterval, vcfRecord2.marker())) continue;
            vcfRecord = vcfRecord2;
        }
        return vcfRecord;
    }

    private static VcfRecord readNextRecord(SampleFileIterator<VcfRecord> sampleFileIterator, ChromInterval chromInterval) {
        VcfRecord vcfRecord;
        VcfRecord vcfRecord2 = null;
        if (sampleFileIterator.hasNext() && IntervalVcfIterator.inInterval(chromInterval, (vcfRecord = (VcfRecord)sampleFileIterator.next()).marker())) {
            vcfRecord2 = vcfRecord;
        }
        return vcfRecord2;
    }

    private static boolean inInterval(ChromInterval chromInterval, Marker marker) {
        return marker.chromIndex() == chromInterval.chromIndex() && chromInterval.start() <= marker.pos() && marker.pos() <= chromInterval.end();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("IntervalVcfIterator.remove()");
    }

    @Override
    public void close() {
        this.it.close();
    }
}

