/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.samtools.util.SeekableStream;

public class SeekableFileStream
extends SeekableStream {
    File file;
    RandomAccessFile fis;

    public SeekableFileStream(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new RandomAccessFile(file, "r");
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean eof() throws IOException {
        return this.fis.length() == this.fis.getFilePointer();
    }

    @Override
    public void seek(long l) throws IOException {
        this.fis.seek(l);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.fis.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            if (n3 > 0) {
                return n3;
            }
            return n4;
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public String getSource() {
        return this.file.getAbsolutePath();
    }
}

