/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.FileUtil;
import blbutil.Utilities;
import dag.Dag;
import dag.DagUtils;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import main.NuclearFamilies;
import main.Parameters;
import vcf.Data;
import vcf.Marker;
import vcf.Markers;

public class RunStats {
    private static final String shortHelp = "beagle.jar (r1399)" + Const.nl + "Copyright (C) 2014 Brian L. Browning" + Const.nl + "Enter \"java -jar beagle.jar\" for a summary of command line " + "arguments.";
    private static final DecimalFormat df2 = new DecimalFormat("0.00");
    private final Parameters par;
    private final PrintWriter log;
    private final long startMillis = System.currentTimeMillis();
    private long buildMillis = 0L;
    private long lastBuildMillis = 0L;
    private long singleSampleMillis = 0L;
    private long duoSampleMillis = 0L;
    private long trioSampleMillis = 0L;
    private long totalSampleMillis = 0L;
    private long totalIbdMillis = 0L;
    private String singleDagStats = null;
    private String duoDagStats = null;
    private String trioDagStats = null;

    RunStats(Parameters parameters) {
        this.par = parameters;
        this.log = RunStats.log(parameters.out());
    }

    private static PrintWriter log(String string) {
        File file = new File(string + ".log");
        boolean bl = false;
        int n = 0;
        return FileUtil.printWriter(file, bl, n);
    }

    void printStartInfo() {
        Utilities.duoPrint(this.log, shortHelp + Const.nl);
        Utilities.duoPrintln(this.log, "Start time: " + Utilities.timeStamp());
        Utilities.duoPrint(this.log, Utilities.commandLine("beagle.jar", this.par.args()));
    }

    void printSummaryAndClose(int n) {
        long l = System.currentTimeMillis() - this.startMillis;
        Utilities.duoPrint(this.log, Const.nl + "Number of markers:             " + n + Const.nl);
        Utilities.duoPrint(this.log, Utilities.printElapsedTime("Total time for building model: ", this.buildMillis));
        Utilities.duoPrint(this.log, Utilities.printElapsedTime("Total time for sampling:       ", this.totalSampleMillis));
        if (this.par.ibd()) {
            Utilities.duoPrint(this.log, Utilities.printElapsedTime("Total time for IBD detection:  ", this.totalIbdMillis));
        }
        Utilities.duoPrint(this.log, Utilities.printElapsedTime("Total run time:                ", l));
        Utilities.duoPrintln(this.log, Const.nl + "End time: " + Utilities.timeStamp());
        Utilities.duoPrintln(this.log, "beagle.jar (r1399) finished");
        this.log.close();
    }

    void buildMillis(long l) {
        this.buildMillis += l;
    }

    void singleSampleMillis(long l) {
        this.singleSampleMillis = l;
        this.totalSampleMillis += l;
    }

    void duoSampleMillis(long l) {
        this.duoSampleMillis = l;
        this.totalSampleMillis += l;
    }

    void trioSampleMillis(long l) {
        this.trioSampleMillis = l;
        this.totalSampleMillis += l;
    }

    void ibdMillis(long l) {
        this.totalIbdMillis += l;
    }

    void setSingleDagStats(Dag dag) {
        this.singleDagStats = dag == null ? null : DagUtils.dagStats(dag);
    }

    void setDuoDagStats(Dag dag) {
        this.duoDagStats = dag == null ? null : DagUtils.dagStats(dag);
    }

    void setTrioDagStats(Dag dag) {
        this.trioDagStats = dag == null ? null : DagUtils.dagStats(dag);
    }

    void printRefinedIbdUpdate(float f, Dag dag, long l) {
        Utilities.duoPrint(this.log, Const.nl + "Refined IBD");
        Utilities.duoPrint(this.log, Const.nl + "model scale: " + df2.format(f));
        Utilities.duoPrint(this.log, Const.nl + Utilities.printElapsedTime("run time:    ", l));
        Utilities.duoPrint(this.log, Const.nl + DagUtils.dagStats(dag));
    }

    void printSampleSummary(NuclearFamilies nuclearFamilies, Data data) {
        Utilities.duoPrint(this.log, Const.nl + "reference samples: " + data.nRefSamples());
        Utilities.duoPrint(this.log, Const.nl + "target samples:    " + data.nNonRefSamples());
        Utilities.duoPrint(this.log, Const.nl + "  singles: " + nuclearFamilies.nSingles());
        Utilities.duoPrint(this.log, Const.nl + "  duos:    " + nuclearFamilies.nDuos());
        Utilities.duoPrintln(this.log, Const.nl + "  trios:   " + nuclearFamilies.nTrios());
    }

    void printWindowUpdate(Data data) {
        Markers markers = data.markers();
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.nMarkers() - 1);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(Const.nl);
        stringBuilder.append("Window ");
        stringBuilder.append(data.window());
        stringBuilder.append(" [ ");
        String string = marker.chrom();
        if (!string.equals(".")) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        stringBuilder.append(marker.pos());
        stringBuilder.append('-');
        if (!string.equals(marker2.chrom())) {
            stringBuilder.append(marker2.chrom());
            stringBuilder.append(':');
        }
        stringBuilder.append(marker2.pos());
        stringBuilder.append(" ]");
        stringBuilder.append(Const.nl);
        if (data.nRefSamples() > 0) {
            stringBuilder.append("reference markers: ");
            stringBuilder.append(data.nMarkers());
            stringBuilder.append(Const.nl);
        }
        stringBuilder.append("target markers:    ");
        stringBuilder.append(data.nNonRefMarkers());
        Utilities.duoPrintln(this.log, stringBuilder.toString());
    }

    void println(String string) {
        Utilities.duoPrintln(this.log, string);
    }

    void printIterationUpdate(int n, int n2) {
        long l = this.buildMillis - this.lastBuildMillis;
        this.lastBuildMillis = this.buildMillis;
        Utilities.duoPrint(this.log, Const.nl + "Window=" + n + " Iteration=" + n2 + Const.nl);
        Utilities.duoPrint(this.log, Utilities.printElapsedTime("Time for building model:         ", l));
        if (this.singleDagStats != null) {
            Utilities.duoPrint(this.log, Utilities.printElapsedTime("Time for sampling (singles):     ", this.singleSampleMillis));
        }
        if (this.duoDagStats != null) {
            Utilities.duoPrint(this.log, Utilities.printElapsedTime("Time for sampling (duos):        ", this.duoSampleMillis));
        }
        if (this.trioDagStats != null) {
            Utilities.duoPrint(this.log, Utilities.printElapsedTime("Time for sampling (trios):       ", this.trioSampleMillis));
        }
        if (this.singleDagStats != null) {
            Utilities.duoPrint(this.log, "Singles model" + Const.nl);
            Utilities.duoPrint(this.log, this.singleDagStats);
        }
        if (this.duoDagStats != null) {
            Utilities.duoPrint(this.log, "Duos model" + Const.nl);
            Utilities.duoPrint(this.log, this.duoDagStats);
        }
        if (this.trioDagStats != null) {
            Utilities.duoPrint(this.log, "Trios model" + Const.nl);
            Utilities.duoPrint(this.log, this.trioDagStats);
        }
        this.log.flush();
    }
}

