% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_slider_pair.R
\name{control_slider_pair}
\alias{control_slider_pair}
\title{A pair of sliders to modify the range of two continuous simulation variables.}
\arguments{
\item{inject}{A vector of the two strings for each variable name to be
modified/injected by the two sliders. For example, \code{inject = c("A", "B")}.}

\item{minimum}{A vector of the two minimum values for each variable in \code{inject}.}

\item{maximum}{A vector of the two maximum values for each variable in \code{inject}.}

\item{label}{A vector of the two small caption/labels for each slider.}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{showGrid()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}
}
\value{
Nothing.
}
\description{
The \code{control_slider_pair} widget displays two movable sliders to drag and
select new numeric values of two simulation variable.
}
\section{Usage}{

   \preformatted{control_slider_pair(inject = c("", ""), minimum = c(0, 0),
   maximum = c(100, 100), label = "", size = 1, placeOnGrid = c(1, 1))}
}

\examples{
\dontrun{

     A <- 0
     B <- 50
     for (i in 1:500) {
       switchboard(delay = 0.01) \%>\%
         control_slider_pair(inject = c("A", "B"),
                             label = c("0 to 100", "0 to 100")) \%>\%
         number_pair(c(A, B))
     }
     switchboard_close()

}

}
\seealso{
Other injectors: 
\code{\link{control_slider_Y_pair}()},
\code{\link{control_slider_Y}()},
\code{\link{control_slider}()},
\code{\link{control_switch_pair}()},
\code{\link{control_switch_trio}()},
\code{\link{control_switch}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()},
\code{\link{injector}()}
}
\concept{injectors}
