% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{fast_lca}
\alias{fast_lca}
\title{Latent Class Analysis}
\usage{
fast_lca(dat, k, tol = 1e-08, posterior = FALSE, transform = 1, sep = "_")
}
\arguments{
\item{dat}{Input data: can be a table or a data frame.}

\item{k}{Numeric specification of the number of latent classes to compute.}

\item{tol}{Numeric specification of the convergence criterion.}

\item{posterior}{Logical indicating whether the posterior probabilities of the individual observations should also be returned.}

\item{transform}{Numeric specification of the power transformation to be applied on the posterior distribution; see \code{\link{fast_psa}}.}

\item{sep}{Character specifying the separator string for joining the levels (if \code{posterior = TRUE}).}
}
\value{
A list with components:
\item{\code{prob0} }{The probabilities of the latent classes.}
\item{\code{prob1}-\code{prob...} }{The probabilities for each set of levels. The columns of each \code{prob...} sum to 1.}
\item{\code{posterior} }{If \code{posterior = TRUE}: An indicator matrix with the posterior probabilities of each observation.}
}
\description{
A fast procedure for computing latent class analysis.
}
\details{
The prior probabilities of the latent classes are initialized with a Dirichlet distribution (by means of \code{rdirichlet} from
  the package \pkg{gtools}) with \code{alpha =} the total frequency counts of every level.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
lca.SndT_Fra <- fast_lca(SndT_Fra, k = 7)
lca.SndT_Fra
}
\references{
Agresti, A. (2013) \emph{Categorical data analysis}. Hoboken: John Wiley and Sons, 535--542.
}
