% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvplot_list.R
\name{ggsurvplot_list}
\alias{ggsurvplot_list}
\title{Plot a List of Survfit Objects}
\usage{
ggsurvplot_list(fit, data, title = NULL, legend.labs = NULL,
  legend.title = "Strata", ...)
}
\arguments{
\item{fit}{a list of survfit objects.}

\item{data}{data used to fit survival curves. Can be also a list of same
length than \code{fit}.}

\item{title}{title of the plot. Can be a character vector or a list of titles
of same length than \code{fit}. If \code{title} is not specified and
\code{fit} is a named list, then the names of fit list are used as title.}

\item{legend.labs}{character vector specifying legend labels. Used to replace
the names of the strata from the fit. Should be given in the same order as
those strata. Can be a list when \code{fit} is a list.}

\item{legend.title}{legend title for each plot. Can be a character vector or a
list of titles of same length than fit.}

\item{...}{other arguments passed to the core function
\code{\link{ggsurvplot}}}
}
\value{
Returns a list of ggsurvplots.
}
\description{
Take a list of survfit objects and produce a list of
 \code{ggsurvplots}.
}
\examples{

library(survival)

# Create a list of formulas
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::
data(colon)
f1 <- survfit(Surv(time, status) ~ adhere, data = colon)
f2 <- survfit(Surv(time, status) ~ rx, data = colon)
fits <- list(sex = f1, rx = f2)

# Visualize
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::
legend.title <- list("sex", "rx")
ggsurvplot_list(fits, colon, legend.title = legend.title)

}
\seealso{
\code{\link{ggsurvplot}}
}
