% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{c_index}
\alias{c_index}
\title{Compute the Harrell's Concordance index}
\usage{
c_index(y_true = NULL, risk = NULL, surv = NULL, times = NULL)
}
\arguments{
\item{y_true}{a \code{survival::Surv} object containing the times and statuses of observations for which the metric will be evaluated}

\item{risk}{a numeric vector of risk scores corresponding to each observation}

\item{surv}{ignored, left for compatibility with other metrics}

\item{times}{ignored, left for compatibility with other metrics}
}
\value{
numeric from 0 to 1, higher values indicate better performance
}
\description{
A function to compute the Harrell's concordance index of a survival model.
}
\section{References}{

\itemize{
\item [1] Harrell, F.E., Jr., et al. \href{https://onlinelibrary.wiley.com/doi/10.1002/sim.4780030207}{"Regression modelling strategies for improved prognostic prediction."} Statistics in Medicine 3.2 (1984): 143-152.
}
}

\examples{
\donttest{
library(survival)
library(survex)

rotterdam <- survival::rotterdam
rotterdam$year <- NULL
cox_rotterdam_rec <- coxph(Surv(rtime, recur) ~ .,
    data = rotterdam,
    model = TRUE, x = TRUE, y = TRUE
)
coxph_explainer <- explain(cox_rotterdam_rec)

risk <- coxph_explainer$predict_function(coxph_explainer$model, coxph_explainer$data)
c_index(y_true = coxph_explainer$y, risk = risk)
}

}
\seealso{
\code{\link[=loss_one_minus_c_index]{loss_one_minus_c_index()}}
}
