% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.Surv}
\alias{plot.Surv}
\title{Plot Survival object}
\usage{
\method{plot}{Surv}(x, l = 3, ...)
}
\arguments{
\item{x}{A \code{Surv} object}

\item{l}{Length of arrow. Length is \code{l/nrow(x)}}

\item{...}{Additional arguments. These are passed to \code{graphics::arrows} when
drawing right- or left-censored observations.}
}
\value{
A graph (base graphics).
The type of graph depends on the \code{type} of the \code{Surv} object.
This is given by \code{attr(s, which="type")} :
\item{counting}{Lines with an arrow pointing right if right censored}
\item{right}{Lines with an arrow pointing right if right censored}
\item{left}{Lines with an arrow pointing left if left censored}
\item{interval}{If censored:
 \itemize{
   \item Lines with an arrow pointing right if right censored.
   \item Lines with an arrow pointing left if left censored.
 }
If not censored:
 \itemize{
   \item Lines if observations of more than one time point
   \item Points if observation of one time only (i.e. start and end times are the same)
 }
}
}
\description{
Plots an object of class \code{Surv}.
\cr
Different methods apply to different types of \code{Surv} objects.
}
\examples{
df0 <- data.frame(t1=c(0, 2, 4, 6, NA, NA, 12, 14),
                  t2=c(NA, NA, 4, 6, 8, 10, 16, 18))
s5 <- Surv(df0$t1, df0$t2, type="interval2")
plot(s5)
}
\keyword{plot}

