% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plotTerm}
\alias{plotTerm}
\title{Plot individual terms of a Generalized Additive \code{gam}
or Cox Proportional Hazards \code{coxph} Model}
\usage{
plotTerm(x, term = 1, se = TRUE, p = 0.95, rug = TRUE, const = 0,
  col = 1, xlab = NULL, data, ...)
}
\arguments{
\item{x}{The result of a Generalized Additive Model (\code{gam})
or a Cox proportional hazards model (\code{coxph})}

\item{term}{The term to be plotted.
An integer, based on the position of the term on the right-hand side
of the model formula e.g. the first term is \code{1}.}

\item{se}{If \code{se=TRUE} (the default), also plot confidence intervals
based on the standard errors}

\item{p}{P-value used to plot the confidence intervals
from standard errors. Based on the normal distribution}

\item{rug}{Add rug (1-dimensional plot) to x-axis.
See \code{?graphics::rug}}

\item{const}{Value for constant term. If \code{const=TRUE},
add the overall mean for the decomposition as returned by
\code{\link{gamTerms}}}

\item{col}{Color of line(s) on plot. If \code{se=TRUE}, use a
\code{vector} of 3 colors: the first is the main line,
the second is lower the CI, the third is the upper CI.}

\item{data}{A \code{data.frame} in which to evaluate the model.
If missing, \code{eval(x$call$data)} is used.}

\item{xlab}{Label for x-axis.}

\item{...}{Additional arguments; passed to \code{graphics::matplot}
(with standard errors) or \code{graphics::plot} (without).}
}
\value{
A plot (base graphics) of the term in question.
If \code{se=TRUE},
this is done using \code{graphics::matplot} otherwise
\code{graphics::plot} is used.
}
\description{
Plot individual terms of a Generalized Additive \code{gam}
or Cox Proportional Hazards \code{coxph} Model
}
\examples{
fit1 <- coxph(Surv(time, status) ~ sex + pspline(age), data=lung)
plotTerm(fit1, term=2, rug=FALSE, ylab="Log-hazard",
         col=c("blue", "red", "red"))
### smoothing splines
data(mpip)
c1 <- coxph(Surv(futime, status) ~
            pspline(lved) + factor(nyha) + rales + pspline(ef),
            data=mpip)
plotTerm(c1, 4, ylab="Log-hazard", xlab="Ejection fraction (\%)",
         main="Log-hazard by ejection fraction \\n Line fitted by penalized smoothing splines")
}
\author{
Terry Therneau. Updated from S-plus by Chris Dardis
}
\seealso{
\code{\link{gamTerms}}, \code{\link{mpip}}
}

