% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm25.R
\name{bm25}
\alias{bm25}
\title{Best Matching(BM25)}
\description{
Computer BM25 distance between sentences/documents.
}
\details{
BM25 stands for Best Matching 25. It is widely using for ranking documents and a preferred method than TF*IDF scores.
It is used to find the similar documents from a corpus, given a new document. It is popularly used in information retrieval systems.
This implementation uses multiple cores for faster and parallel computation.
}
\examples{

## ------------------------------------------------
## Method `bm25$new`
## ------------------------------------------------

example <- c('white audi 2.5 car','black shoes from office',
             'new mobile iphone 7','audi tyres audi a3',
             'nice audi bmw toyota corolla')
obj <- bm25$new(example, use_parallel=FALSE)

## ------------------------------------------------
## Method `bm25$most_similar`
## ------------------------------------------------

example <- c('white audi 2.5 car','black shoes from office',
             'new mobile iphone 7','audi tyres audi a3',
             'nice audi bmw toyota corolla')
get_bm <- bm25$new(example, use_parallel=FALSE)
input_document <- c('white toyota corolla')
get_bm$most_similar(document = input_document, topn = 2)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{corpus}}{a list containing sentences}

\item{\code{use_parallel}}{enables parallel computation, defaults to FALSE}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{bm25$new()}}
\item \href{#method-most_similar}{\code{bm25$most_similar()}}
\item \href{#method-clone}{\code{bm25$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bm25$new(corpus, use_parallel)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{corpus}}{list, a list containing sentences}

\item{\code{use_parallel}}{logical, enables parallel computation, defaults to FALSE. if TRUE uses n - 1 cores.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new `bm25` object.
}

\subsection{Returns}{
A `bm25` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{example <- c('white audi 2.5 car','black shoes from office',
             'new mobile iphone 7','audi tyres audi a3',
             'nice audi bmw toyota corolla')
obj <- bm25$new(example, use_parallel=FALSE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-most_similar"></a>}}
\subsection{Method \code{most_similar()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bm25$most_similar(document, topn = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{document}}{character, for this value we find most similar sentences.}

\item{\code{topn}}{integer, top n sentences to retrieve}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns a list of the most similar sentence
}

\subsection{Returns}{
a vector of most similar documents
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{example <- c('white audi 2.5 car','black shoes from office',
             'new mobile iphone 7','audi tyres audi a3',
             'nice audi bmw toyota corolla')
get_bm <- bm25$new(example, use_parallel=FALSE)
input_document <- c('white toyota corolla')
get_bm$most_similar(document = input_document, topn = 2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{bm25$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
