% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{label}
\alias{label}
\title{Get Variable or Data Frame Label}
\usage{
label(x, all = FALSE, fallback = FALSE, simplify = FALSE)
}
\arguments{
\item{x}{An R object to extract labels from}

\item{all}{Logical. When x is a data frame, setting this argument to \code{TRUE} will
make the function return all variable labels. By default, its value is \code{FALSE},
so that if x is a data frame, it is the data frame's label that will be returned.}

\item{fallback}{a logical value indicating if labels should fallback to object name(s).
Defaults to \code{FALSE}.}

\item{simplify}{When x is a data frame and \code{all = TRUE}, coerce results to a vector
when \code{TRUE}, otherwise (default) return a \code{named list} containing only
non-NULL/non-NA elements.}
}
\description{
Returns character value previously stored in variable or data
frame's \code{label} attribute, or \code{NA} if none found.
}
\note{
Loosely based on Gergely Daróczi's \code{\link[rapportools]{label}} function.
}
\references{
\url{https://github.com/Rapporter/rapportools}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com},
Gergely Daróczi, \email{daroczig@rapporter.net}
}
