/**
 * [SubspaceClusteringTabPanel.java] for Subspace MOA
 * 
 * "SubspaceClustering" tab.
 * (SetupTab + VisualTab)
 * 
 * @author Yunsu Kim
 * 		   based on the implementation of Timm Jansen
 * Data Management and Data Exploration Group, RWTH Aachen University
 */

package moa.gui.subspaceclusteringtab;

import moa.gui.AbstractTabPanel;

public class SubspaceClusteringTabPanel extends AbstractTabPanel {

    private static final long serialVersionUID = 1L;

	/** Creates new form ClusterTab */
    public SubspaceClusteringTabPanel() {
        initComponents();
        subspaceClusteringVisualTab.setClusteringSetupTab(subspaceClusteringSetupTab);
        subspaceClusteringSetupTab.addButtonActionListener(subspaceClusteringVisualTab);
        subspaceClusteringSetupTab.setClusteringTab(this);
    }

    void toggle() {
        subspaceClusteringVisualTab.toggleVisualizer(false);
    }

    void stop() {
        subspaceClusteringVisualTab.stopVisualizer();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        subspaceClusteringSetupTab = new moa.gui.subspaceclusteringtab.SubspaceClusteringSetupTab();
        subspaceClusteringVisualTab = new moa.gui.subspaceclusteringtab.SubspaceClusteringVisualTab();

        setLayout(new java.awt.BorderLayout());

        jTabbedPane1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTabbedPane1MouseClicked(evt);
            }
        });
        jTabbedPane1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTabbedPane1FocusGained(evt);
            }
        });
        jTabbedPane1.addTab("Setup", subspaceClusteringSetupTab);
        jTabbedPane1.addTab("Visualization", subspaceClusteringVisualTab);

        add(jTabbedPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void jTabbedPane1FocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTabbedPane1FocusGained
        
    }//GEN-LAST:event_jTabbedPane1FocusGained

    private void jTabbedPane1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTabbedPane1MouseClicked
        
    }//GEN-LAST:event_jTabbedPane1MouseClicked



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private moa.gui.subspaceclusteringtab.SubspaceClusteringSetupTab subspaceClusteringSetupTab;
    private moa.gui.subspaceclusteringtab.SubspaceClusteringVisualTab subspaceClusteringVisualTab;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables

    //returns the string to display as title of the tab
    public String getTabTitle() {
            return "SubspaceClustering";
    }

    //a short description (can be used as tool tip) of the tab, or contributor, etc.
    public String getDescription(){
            return "MOA Subspace Clustering";
    }


}
