% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/file_io.R
\name{clustering_from_file}
\alias{clustering_from_file}
\title{Reads a Clustering Object from a File}
\usage{
clustering_from_file(file_path, index_starts_at = 0, dim = NULL)
}
\arguments{
\item{file_path}{The path to the File from which the clustering should be read}

\item{index_starts_at}{The index used in the file to refer to the first object
in The data matrix}

\item{dim}{if provided, overrides any value for dim that is found in the first
 line of the file}
}
\description{
Reads a File and creates an object of class \emph{subspace_clustering} from
that.
}
\note{
Files must have the following Format: The first line contains the
 substring "DIM=*dim*;" where *dim* is the number of dimensions of the data
 set.

 Each subsequent line corresponds to a cluster and contains only numbers
 separated by spaces. The first *dim* of these values have to be either '0'
 or '1' and indicate in which subspace a cluster exists. All other values in
 the line have to be the row numbers of the objects that the cluster
 contains. Row numbers in the file are assumed to be 0-indexed and are
 changed to 1-indexed as they are loaded into R. This can be changed with the
 parameter \emph{index_starts_at}. E.g. a clustering for a three-dimensional
 dataset with one cluster that is in the first and third dimension and
 contains the first, second and 1337-th object has to be represented as:

 DIM=3;\cr 1 0 1 0 1 1336
}
\seealso{
\code{\link{clustering_to_file}}
}

