% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_guides.R
\name{math_token_spacing}
\alias{math_token_spacing}
\alias{specify_math_token_spacing}
\alias{tidyverse_math_token_spacing}
\title{Specify spacing around math tokens}
\usage{
specify_math_token_spacing(zero = NULL, one = c("'+'", "'-'", "'*'", "'/'",
  "'^'"))

tidyverse_math_token_spacing()
}
\arguments{
\item{zero}{Character vector of tokens that should be surrounded with zero
spaces.}

\item{one}{Character vector with tokens that should be surrounded by at
least one space (depending on \code{strict = TRUE} in the styling functions
\code{\link[=style_text]{style_text()}} and friends). See 'Examples'.}
}
\description{
Helper function to create the input for the argument \code{math_token_spacing}  in
\code{\link[=tidyverse_style]{tidyverse_style()}}.
}
\section{Functions}{
\itemize{
\item \code{specify_math_token_spacing}: Allows to fully specify the math token
spacing.

\item \code{tidyverse_math_token_spacing}: Simple forwarder to
\code{specify_math_token_spacing} with spacing around math tokens according to the
tidyverse style guide.
}}

\examples{
style_text(
  "1+1   -3",
  math_token_spacing = specify_math_token_spacing(zero = "'+'"),
  strict = FALSE
)
style_text(
  "1+1   -3",
  math_token_spacing = specify_math_token_spacing(zero = "'+'"),
  strict = TRUE
)
style_text(
  "1+1   -3",
  math_token_spacing = tidyverse_math_token_spacing(),
  strict = TRUE
)
style_text(
  "1+1   -3",
  math_token_spacing = tidyverse_math_token_spacing(),
  strict = TRUE
)
}
