% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.structured.R
\name{print.structured}
\alias{plot.structured}
\alias{print.structured}
\alias{print.summary.structured}
\alias{summary.structured}
\title{Methods for Structured Objects}
\usage{
\method{print}{structured}(x, legendLoc = c("left", "right", "top", "bottom",
  "newpage"), legend = defaultStrucLegend, abbrevLength = 0, ...)

\method{plot}{structured}(...)

\method{summary}{structured}(object, ...)

\method{print}{summary.structured}(x, ...)
}
\arguments{
\item{x, object}{The object to be displayed or summarized.}

\item{legendLoc}{An optional location of a legend describing the plot layout
  to be used as a legend on the trellis plot. Note that a text legend is
  \emph{always} printed on the console. If used, this argument specified the
  position of a legend in the trellis display. It must be one of
  \code{"left"}, \code{"right"}, \code{"top"}, \code{"bottom"}, or
  \code{"newpage"} (matching is done using \code{\link{match.arg}}, so
  \code{legendLoc} can be abbreviated). Any of the first four of these will
  become the name of a component of the \code{legend} argument of the
  \code{\link[lattice]{xyplot}} call, and so must not conflict with any in a
  \code{legend} argument that may already be part of the
  \code{\link{strucplot}} call.

If \code{legendLoc = "newpage"}, the legend will be plotted centered on a new
trellis page.}

\item{legend}{A \emph{function} that constructs a grob to use as a plot legend. It
must accept at least 2 arguments, \code{"struc"} and \code{"legendLoc"}, which
will be passed the \code{"structure"} attribute of the object to
be plotted and the \code{legendLoc} argument above.
Additional arguments may be passed in the \dots argument of the print
call (below).

The default is the unexported \code{\link{defaultStrucLegend}} function.
Its Help file should be consulted for its full argument list.}

\item{abbrevLength}{Default = 0. A non-zero value of this argument is used as
the \code{minlength} argument of the \code{\link{abbreviate}} function to
abbreviate the names of the conditioning factors both in the automatically
generated console legend and the optional plot legend.}

\item{...}{Further arguments to pass down to either the \code{legend} function
or \code{\link[lattice]{print.trellis}}, which should be consulted for details.
Care should be taken to ensure that the names of arguments do not coincide.
See \code{\link{defaultStrucLegend}} for arguments for the default \code{legend}
function.}
}
\description{
Print/plot and summary methods for class 'structured' objects.
}
\details{
The \code{print} and \code{plot} methods produce a plot and informative legend
for "structured" objects. The \code{plot} method is an alias for the print
method. The \code{summary} method gives a simple summary of the object.
}
\note{
Do not use the \code{packet.panel} argument of \code{print.trellis},
 as this will totally mess up the display.
}
\examples{
require(datasets)
# quakes data
#
# Create and save plot
out <- strucplot(lat ~ long|cut(mag,5)*cut(depth,4), data = quakes,
  col="blue", main = "Earthquake locations, by magnitude and depth")

# Summary:
summary(out)

# Default output -- structure legend on console only
   print(out)

# Add legends to the plot on either right or bottom (note partial matching)
   print(out, legendLoc = "right")
   print(out, legendLoc = "b")
#
# Abbreviate the conditioning factor names
   print(out, legendLoc = "b", abbrev = 5)
#
# Plot the legend by itself on a separate page
   print(out, legendLoc = "newp")
#
# Extra grid "gp" arguments to alter text appearance
   print(out, legendLoc = "b",col="blue",fontface = "italic",
   abbrev = 5)

}
\seealso{
\code{\link[lattice]{print.trellis}}
}

