/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.featureranking;

import java.util.HashMap;
import java.util.Map;
import moa.classifiers.rules.featureranking.AbstractFeatureRanking;
import moa.classifiers.rules.featureranking.FeatureRanking;
import moa.classifiers.rules.featureranking.messages.ChangeDetectedMessage;
import moa.classifiers.rules.featureranking.messages.MeritCheckMessage;
import moa.classifiers.rules.featureranking.messages.RuleExpandedMessage;
import moa.classifiers.rules.multilabel.core.ObservableMOAObject;
import moa.core.DoubleVector;

public class MeritFeatureRanking
extends AbstractFeatureRanking
implements FeatureRanking {
    private static final long serialVersionUID = 1L;
    protected DoubleVector attributeImportance = new DoubleVector();
    protected HashMap<ObservableMOAObject, RuleInformation> ruleInformation = new HashMap();

    @Override
    public void update(ObservableMOAObject o, Object arg) {
        if (arg instanceof MeritCheckMessage) {
            RuleInformation ri = this.ruleInformation.get(o);
            if (ri == null) {
                ri = new RuleInformation();
                this.ruleInformation.put(o, ri);
            }
            DoubleVector merits = ri.getCurrent();
            if (!ri.isFirstAfterExpansion()) {
                this.attributeImportance.subtractValues(merits);
            }
            MeritCheckMessage msg = (MeritCheckMessage)arg;
            ri.updateCurrent(msg.getMerits());
            merits = ri.getCurrent();
            this.attributeImportance.addValues(merits);
        } else if (arg instanceof RuleExpandedMessage) {
            RuleInformation ri = this.ruleInformation.get(o);
            if (!((RuleExpandedMessage)arg).isSpecialization()) {
                ri.addNumLiterals();
            }
        } else if (arg instanceof ChangeDetectedMessage) {
            RuleInformation ri = this.ruleInformation.get(o);
            this.attributeImportance.subtractValues(ri.getAccumulated());
            this.ruleInformation.remove(o);
        }
    }

    @Override
    public DoubleVector getFeatureRankings() {
        if (this.attributeImportance == null) {
            return new DoubleVector();
        }
        return this.attributeImportance;
    }

    public DoubleVector getAccumulated() {
        DoubleVector accumulated = new DoubleVector();
        for (Map.Entry<ObservableMOAObject, RuleInformation> pair : this.ruleInformation.entrySet()) {
            accumulated.addValues(pair.getValue().getAccumulated());
        }
        return accumulated;
    }

    public class RuleInformation {
        private DoubleVector accumulated = new DoubleVector();
        private DoubleVector current = new DoubleVector();
        private boolean isFirstAfterExpansion = false;
        private int numLiterals = 0;

        public DoubleVector getAccumulated() {
            return this.accumulated;
        }

        public DoubleVector getCurrent() {
            return this.current;
        }

        public void updateCurrent(DoubleVector merits) {
            DoubleVector newMerits = new DoubleVector(merits);
            if (!this.isFirstAfterExpansion) {
                this.accumulated.subtractValues(this.current);
            }
            newMerits.scaleValues(1.0 / (double)(1 + this.numLiterals));
            this.accumulated.addValues(newMerits);
            this.current = newMerits;
            this.isFirstAfterExpansion = false;
        }

        public void addNumLiterals() {
            ++this.numLiterals;
            this.isFirstAfterExpansion = true;
        }

        public boolean isFirstAfterExpansion() {
            return this.isFirstAfterExpansion;
        }
    }
}

