/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.SVMLightLoader;

public class SVMLightSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    private static final long serialVersionUID = 2605714599263995835L;
    public static String FILE_EXTENSION = SVMLightLoader.FILE_EXTENSION;
    public static int MAX_DIGITS = 18;
    protected SingleIndex m_ClassIndex = new SingleIndex("last");

    public SVMLightSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in svm light format.\n\nFor more information about svm light see:\n\nhttp://svmlight.joachims.org/";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tThe class index\n\t(default: last)", "c", 1, "-c <class index>"));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-c");
        result.add(this.getClassIndex());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('c', options);
        if (tmpStr.length() != 0) {
            this.setClassIndex(tmpStr);
        } else {
            this.setClassIndex("last");
        }
    }

    @Override
    public String getFileDescription() {
        return "svm light data files";
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(SVMLightLoader.FILE_EXTENSION);
    }

    public String classIndexTipText() {
        return "Sets the class index (\"first\" and \"last\" are valid values)";
    }

    public String getClassIndex() {
        return this.m_ClassIndex.getSingleIndex();
    }

    public void setClassIndex(String value) {
        this.m_ClassIndex.setSingleIndex(value);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        return result;
    }

    @Override
    public void setInstances(Instances instances) {
        this.m_ClassIndex.setUpper(instances.numAttributes() - 1);
        instances.setClassIndex(this.m_ClassIndex.getIndex());
        super.setInstances(instances);
    }

    protected String instanceToSvmlight(Instance inst) {
        StringBuffer result = new StringBuffer();
        if (inst.classAttribute().isNominal()) {
            if (inst.classValue() == 0.0) {
                result.append("1");
            } else if (inst.classValue() == 1.0) {
                result.append("-1");
            }
        } else {
            result.append("" + Utils.doubleToString(inst.classValue(), MAX_DIGITS));
        }
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (i == inst.classIndex() || inst.value(i) == 0.0) continue;
            result.append(" " + (i + 1) + ":" + Utils.doubleToString(inst.value(i), MAX_DIGITS));
        }
        return result.toString();
    }

    @Override
    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure (Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                if (this.retrieveFile() == null && outW == null) {
                    System.out.println(this.instanceToSvmlight(inst));
                } else {
                    outW.println(this.instanceToSvmlight(inst));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        outW.flush();
                    }
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    @Override
    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                System.out.println(this.instanceToSvmlight(this.getInstances().instance(i)));
            }
            this.setWriteMode(1);
        } else {
            PrintWriter outW = new PrintWriter(this.getWriter());
            for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                outW.println(this.instanceToSvmlight(this.getInstances().instance(i)));
            }
            outW.flush();
            outW.close();
            this.setWriteMode(1);
            outW = null;
            this.resetWriter();
            this.setWriteMode(2);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        SVMLightSaver.runFileSaver(new SVMLightSaver(), args);
    }
}

