/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import moa.evaluation.MeasureCollection;
import moa.streams.clustering.ClusterEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphCurve
extends JPanel {
    private double min_value = 0.0;
    private double max_value = 1.0;
    private MeasureCollection measure0 = null;
    private MeasureCollection measure1 = null;
    private int measureSelected = 0;
    private double x_resolution;
    private int processFrequency;
    private ArrayList<ClusterEvent> clusterEvents;

    public GraphCurve() {
        this.initComponents();
    }

    public void setGraph(MeasureCollection measure0, MeasureCollection measure1, int selection) {
        this.measure0 = measure0;
        this.measure1 = measure1;
        this.measureSelected = selection;
        this.repaint();
    }

    void setProcessFrequency(int processFrequency) {
        this.processFrequency = processFrequency;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.BLACK);
        if (this.measure0 != null && this.measure1 != null) {
            this.paintFullCurve(g, this.measure0, this.measureSelected, Color.red);
            this.paintFullCurve(g, this.measure1, this.measureSelected, Color.blue);
        } else if (this.measure0 != null) {
            this.paintFullCurve(g, this.measure0, this.measureSelected, Color.red);
        }
        this.paintEvents(g);
    }

    private void paintFullCurve(Graphics g, MeasureCollection m, int mSelect, Color color) {
        if (m.getNumberOfValues(mSelect) == 0) {
            return;
        }
        boolean corrupted = false;
        int height = this.getHeight();
        int width = this.getWidth();
        int n = m.getNumberOfValues(mSelect);
        if (this.x_resolution > 1.0) {
            n /= (int)this.x_resolution;
        }
        int[] x = new int[n];
        int[] y = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.x_resolution > 1.0) {
                double sum_y = 0.0;
                int counter = 0;
                int j = 0;
                while ((double)j < this.x_resolution) {
                    if ((double)i * this.x_resolution + (double)j < (double)m.getNumberOfValues(mSelect)) {
                        sum_y += m.getValue(mSelect, i);
                        ++counter;
                    }
                    sum_y /= (double)counter;
                    ++j;
                }
                x[i] = i;
                y[i] = (int)((double)height - sum_y / this.max_value * (double)height);
                continue;
            }
            x[i] = i * (int)(1.0 / this.x_resolution) + (int)(1.0 / this.x_resolution / 2.0);
            double value = m.getValue(mSelect, i);
            if (Double.isNaN(value)) {
                corrupted = true;
                break;
            }
            y[i] = (int)((double)height - value / this.max_value * (double)height);
        }
        if (!corrupted) {
            g.setColor(color);
            g.drawPolyline(x, y, n);
        }
    }

    private void paintEvents(Graphics g) {
        if (this.clusterEvents != null) {
            g.setColor(Color.DARK_GRAY);
            for (int i = 0; i < this.clusterEvents.size(); ++i) {
                int x = (int)((double)(this.clusterEvents.get(i).getTimestamp() / (long)this.processFrequency) / this.x_resolution);
                g.drawLine(x, 0, x, this.getHeight());
            }
        }
    }

    public void setYMinMaxValues(double min, double max) {
        this.min_value = min;
        this.max_value = max;
    }

    void setClusterEventsList(ArrayList<ClusterEvent> clusterEvents) {
        this.clusterEvents = clusterEvents;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    void setXResolution(double x_resolution) {
        this.x_resolution = x_resolution;
    }

    private void initComponents() {
        this.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1000, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

