/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.classifiers.InstanceConditionalBinaryTest;
import moa.core.InstancesHeader;
import weka.core.Instance;

public class NumericAttributeBinaryTest
extends InstanceConditionalBinaryTest {
    private static final long serialVersionUID = 1L;
    protected int attIndex;
    protected double attValue;
    protected boolean equalsPassesTest;

    public NumericAttributeBinaryTest(int attIndex, double attValue, boolean equalsPassesTest) {
        this.attIndex = attIndex;
        this.attValue = attValue;
        this.equalsPassesTest = equalsPassesTest;
    }

    public int branchForInstance(Instance inst) {
        int instAttIndex;
        int n = instAttIndex = this.attIndex < inst.classIndex() ? this.attIndex : this.attIndex + 1;
        if (inst.isMissing(instAttIndex)) {
            return -1;
        }
        double v = inst.value(instAttIndex);
        if (v == this.attValue) {
            return this.equalsPassesTest ? 0 : 1;
        }
        return v < this.attValue ? 0 : 1;
    }

    public String describeConditionForBranch(int branch, InstancesHeader context) {
        if (branch == 0 || branch == 1) {
            char compareChar = branch == 0 ? (char)'<' : '>';
            int equalsBranch = this.equalsPassesTest ? 0 : 1;
            return InstancesHeader.getAttributeNameString(context, this.attIndex) + ' ' + compareChar + (branch == equalsBranch ? "= " : " ") + InstancesHeader.getNumericValueString(context, this.attIndex, this.attValue);
        }
        throw new IndexOutOfBoundsException();
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    public int[] getAttsTestDependsOn() {
        return new int[]{this.attIndex};
    }

    public double getSplitValue() {
        return this.attValue;
    }
}

