/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.CustomDisplayStringProvider;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.gui.CustomPanelSupplier;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;
import weka.gui.HierarchyPropertyParser;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertySheetPanel;

public class GenericObjectEditor
implements PropertyEditor,
CustomPanelSupplier {
    protected Object m_Object;
    protected Object m_Backup;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Class m_ClassType;
    protected Hashtable m_ObjectNames;
    protected GOEPanel m_EditorComponent;
    protected boolean m_Enabled = true;
    protected static String PROPERTY_FILE = "weka/gui/GenericObjectEditor.props";
    protected static Properties EDITOR_PROPERTIES;
    public static final String GUIEDITORS_PROPERTY_FILE = "weka/gui/GUIEditors.props";
    protected GOETreeNode m_treeNodeOfCurrentObject;
    protected PropertyPanel m_ObjectPropertyPanel;
    protected boolean m_canChangeClassInDialog;
    protected static boolean m_EditorsRegistered;
    protected Capabilities m_CapabilitiesFilter = null;

    public static void determineClasses() {
        block8: {
            try {
                WekaPackageManager.loadPackages(false);
                GenericPropertiesCreator creator = new GenericPropertiesCreator();
                if (creator.useDynamic()) {
                    try {
                        creator.execute(false);
                        EDITOR_PROPERTIES = creator.getOutputProperties();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Could not determine the properties for the generic object\neditor. This exception was produced:\n" + e.toString(), "GenericObjectEditor", 0);
                    }
                    break block8;
                }
                try {
                    EDITOR_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
                    Enumeration<?> keys = EDITOR_PROPERTIES.propertyNames();
                    if (!keys.hasMoreElements()) {
                        throw new Exception("Failed to read a property file for the generic object editor");
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Could not read a configuration file for the generic object\neditor. An example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "GenericObjectEditor", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could not initialize the GenericPropertiesCreator. This exception was produced:\n" + e.toString(), "GenericObjectEditor", 0);
            }
        }
    }

    public GenericObjectEditor() {
        this(false);
    }

    public GenericObjectEditor(boolean canChangeClassInDialog) {
        this.m_canChangeClassInDialog = canChangeClassInDialog;
    }

    public static void registerEditors() {
        Properties props;
        if (m_EditorsRegistered) {
            return;
        }
        System.err.println("---Registering Weka Editors---");
        m_EditorsRegistered = true;
        try {
            props = Utils.readProperties(GUIEDITORS_PROPERTY_FILE);
        }
        catch (Exception e) {
            props = new Properties();
            e.printStackTrace();
        }
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement().toString();
            String value = props.getProperty(name, "");
            GenericObjectEditor.registerEditor(name, value);
        }
    }

    public static void registerEditor(String name, String value) {
        try {
            Class<?> cls;
            if (name.endsWith("[]")) {
                Class<?> baseCls = Class.forName(name.substring(0, name.indexOf("[]")));
                cls = Array.newInstance(baseCls, 1).getClass();
            } else {
                cls = Class.forName(name);
            }
            PropertyEditorManager.registerEditor(cls, Class.forName(value));
        }
        catch (Exception e) {
            System.err.println("Problem registering " + name + "/" + value + ": " + e);
        }
    }

    public void setCanChangeClassInDialog(boolean value) {
        this.m_canChangeClassInDialog = value;
    }

    public boolean getCanChangeClassInDialog() {
        return this.m_canChangeClassInDialog;
    }

    public Object getBackup() {
        return this.m_Backup;
    }

    protected static String getRootFromClass(String clsname, String separator) {
        if (clsname.indexOf(separator) > -1) {
            return clsname.substring(0, clsname.indexOf(separator));
        }
        return null;
    }

    public static Hashtable sortClassesByRoot(String classes) {
        Vector list;
        String root;
        if (classes == null) {
            return null;
        }
        Hashtable<String, Vector> roots = new Hashtable<String, Vector>();
        HierarchyPropertyParser hpp = new HierarchyPropertyParser();
        String separator = hpp.getSeperator();
        StringTokenizer tok = new StringTokenizer(classes, ", ");
        while (tok.hasMoreElements()) {
            String clsname = tok.nextToken();
            root = GenericObjectEditor.getRootFromClass(clsname, separator);
            if (root == null) continue;
            if (!roots.containsKey(root)) {
                list = new Vector();
                roots.put(root, list);
            } else {
                list = (Vector)roots.get(root);
            }
            list.add(clsname);
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration enm = roots.keys();
        while (enm.hasMoreElements()) {
            root = (String)enm.nextElement();
            list = (Vector)roots.get(root);
            String tmpStr = "";
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    tmpStr = tmpStr + ",";
                }
                tmpStr = tmpStr + (String)list.get(i);
            }
            result.put(root, tmpStr);
        }
        return result;
    }

    protected Hashtable getClassesFromProperties() {
        Hashtable<String, HierarchyPropertyParser> hpps = new Hashtable<String, HierarchyPropertyParser>();
        String className = this.m_ClassType.getName();
        Hashtable typeOptions = GenericObjectEditor.sortClassesByRoot(EDITOR_PROPERTIES.getProperty(className));
        if (typeOptions != null) {
            try {
                Enumeration enm = typeOptions.keys();
                while (enm.hasMoreElements()) {
                    String root = (String)enm.nextElement();
                    String typeOption = (String)typeOptions.get(root);
                    HierarchyPropertyParser hpp = new HierarchyPropertyParser();
                    hpp.build(typeOption, ", ");
                    hpps.put(root, hpp);
                }
            }
            catch (Exception ex) {
                System.err.println("Invalid property: " + typeOptions);
            }
        }
        return hpps;
    }

    protected void updateObjectNames() {
        String className;
        String root;
        HierarchyPropertyParser hpp;
        if (this.m_ObjectNames == null) {
            this.m_ObjectNames = this.getClassesFromProperties();
        }
        if (this.m_Object != null && (hpp = (HierarchyPropertyParser)this.m_ObjectNames.get(root = GenericObjectEditor.getRootFromClass(className = this.m_Object.getClass().getName(), new HierarchyPropertyParser().getSeperator()))) != null && !hpp.contains(className)) {
            hpp.add(className);
        }
    }

    public void setEnabled(boolean newVal) {
        if (newVal != this.m_Enabled) {
            this.m_Enabled = newVal;
        }
    }

    public void setClassType(Class type) {
        this.m_ClassType = type;
        this.m_ObjectNames = this.getClassesFromProperties();
    }

    public void setDefaultValue() {
        if (this.m_ClassType == null) {
            System.err.println("No ClassType set up for GenericObjectEditor!!");
            return;
        }
        Hashtable hpps = this.getClassesFromProperties();
        HierarchyPropertyParser hpp = null;
        Enumeration enm = hpps.elements();
        try {
            while (enm.hasMoreElements()) {
                hpp = (HierarchyPropertyParser)enm.nextElement();
                if (hpp.depth() <= 0) continue;
                hpp.goToRoot();
                while (!hpp.isLeafReached()) {
                    hpp.goToChild(0);
                }
                String defaultValue = hpp.fullValue();
                this.setValue(Class.forName(defaultValue).newInstance());
            }
        }
        catch (Exception ex) {
            System.err.println("Problem loading the first class: " + hpp.fullValue());
            ex.printStackTrace();
        }
    }

    @Override
    public void setValue(Object o) {
        if (this.m_ClassType == null) {
            System.err.println("No ClassType set up for GenericObjectEditor!!");
            return;
        }
        if (!this.m_ClassType.isAssignableFrom(o.getClass())) {
            System.err.println("setValue object not of correct type!");
            return;
        }
        this.setObject(o);
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.repaint();
        }
        this.updateObjectNames();
    }

    protected void setObject(Object c) {
        boolean trueChange = this.getValue() != null ? !c.equals(this.getValue()) : true;
        this.m_Backup = this.m_Object;
        this.m_Object = c;
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.updateChildPropertySheet();
        }
        if (trueChange) {
            this.m_Support.firePropertyChange("", null, null);
        }
    }

    @Override
    public Object getValue() {
        Object result = null;
        try {
            result = GenericObjectEditor.makeCopy(this.m_Object);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.m_Object.getClass().getName() + "()";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.m_Enabled) {
            String rep;
            if (this.m_Object != null) {
                if (this.m_Object instanceof CustomDisplayStringProvider) {
                    rep = ((CustomDisplayStringProvider)this.m_Object).toDisplay();
                } else {
                    rep = this.m_Object.getClass().getName();
                    int dotPos = rep.lastIndexOf(46);
                    if (dotPos != -1) {
                        rep = rep.substring(dotPos + 1);
                    }
                }
            } else {
                rep = "None";
            }
            Font originalFont = gfx.getFont();
            gfx.setFont(originalFont.deriveFont(1));
            FontMetrics fm = gfx.getFontMetrics();
            int vpad = box.height - fm.getHeight();
            gfx.drawString(rep, 2, fm.getAscent() + vpad);
            int repwidth = fm.stringWidth(rep);
            gfx.setFont(originalFont);
            if (this.m_Object instanceof OptionHandler && !(this.m_Object instanceof CustomDisplayStringProvider)) {
                gfx.drawString(" " + Utils.joinOptions(((OptionHandler)this.m_Object).getOptions()), repwidth + 2, fm.getAscent() + vpad);
            }
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_EditorComponent == null) {
            this.m_EditorComponent = new GOEPanel();
        }
        return this.m_EditorComponent;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    public JPanel getCustomPanel() {
        JButton chooseButton = this.createChooseClassButton();
        this.m_ObjectPropertyPanel = new PropertyPanel((PropertyEditor)this, true);
        1 customPanel = new /* Unavailable Anonymous Inner Class!! */;
        customPanel.setLayout(new BorderLayout());
        customPanel.add((Component)chooseButton, "West");
        customPanel.add((Component)this.m_ObjectPropertyPanel, "Center");
        return customPanel;
    }

    protected JButton createChooseClassButton() {
        JButton setButton = new JButton("Choose");
        setButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        return setButton;
    }

    protected String getClassnameFromPath(TreePath path) {
        StringBuffer classname = new StringBuffer();
        int start = 0;
        if (this.m_ObjectNames.size() > 1) {
            start = 1;
        }
        for (int i = start; i < path.getPathCount(); ++i) {
            if (i > start) {
                classname.append(".");
            }
            classname.append((String)((GOETreeNode)path.getPathComponent(i)).getUserObject());
        }
        return classname.toString();
    }

    public JPopupMenu getChooseClassPopupMenu() {
        this.updateObjectNames();
        this.m_treeNodeOfCurrentObject = null;
        JTree tree = this.createTree(this.m_ObjectNames);
        if (this.m_treeNodeOfCurrentObject != null) {
            tree.setSelectionPath(new TreePath(this.m_treeNodeOfCurrentObject.getPath()));
        }
        tree.getSelectionModel().setSelectionMode(1);
        JTreePopupMenu popup = new JTreePopupMenu(this, tree);
        tree.addTreeSelectionListener((TreeSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return popup;
    }

    protected JTree createTree(Hashtable hpps) {
        GOETreeNode superRoot = hpps.size() > 1 ? new GOETreeNode(this, (Object)"root") : null;
        Enumeration enm = hpps.elements();
        while (enm.hasMoreElements()) {
            HierarchyPropertyParser hpp = (HierarchyPropertyParser)enm.nextElement();
            hpp.goToRoot();
            GOETreeNode root = new GOETreeNode(this, (Object)hpp.getValue());
            this.addChildrenToTree(root, hpp);
            if (superRoot == null) {
                superRoot = root;
                continue;
            }
            superRoot.add((MutableTreeNode)root);
        }
        JTree tree = new JTree((TreeNode)superRoot);
        return tree;
    }

    protected void addChildrenToTree(GOETreeNode tree, HierarchyPropertyParser hpp) {
        try {
            for (int i = 0; i < hpp.numChildren(); ++i) {
                hpp.goToChild(i);
                GOETreeNode child = new GOETreeNode(this, (Object)hpp.getValue());
                if (this.m_Object != null && this.m_Object.getClass().getName().equals(hpp.fullValue())) {
                    this.m_treeNodeOfCurrentObject = child;
                }
                tree.add((MutableTreeNode)child);
                this.addChildrenToTree(child, hpp);
                hpp.goToParent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void classSelected(String className) {
        try {
            if (this.m_Object != null && this.m_Object.getClass().getName().equals(className)) {
                return;
            }
            this.setValue(Class.forName(className).newInstance());
            if (this.m_EditorComponent != null) {
                this.m_EditorComponent.updateChildPropertySheet();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not create an example of\n" + className + "\n" + "from the current classpath", "Class load failed", 0);
            ex.printStackTrace();
            try {
                if (this.m_Backup != null) {
                    this.setValue(this.m_Backup);
                } else {
                    this.setDefaultValue();
                }
            }
            catch (Exception e) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void setCapabilitiesFilter(Capabilities value) {
        this.m_CapabilitiesFilter = new Capabilities(null);
        this.m_CapabilitiesFilter.assign(value);
    }

    public Capabilities getCapabilitiesFilter() {
        return this.m_CapabilitiesFilter;
    }

    public void removeCapabilitiesFilter() {
        this.m_CapabilitiesFilter = null;
    }

    public static Object makeCopy(Object source) throws Exception {
        SerializedObject so = new SerializedObject(source);
        Object result = so.getObject();
        return result;
    }

    public static Vector<String> getClassnames(String property) {
        Vector<String> result = new Vector<String>();
        String value = EDITOR_PROPERTIES.getProperty(property, "").replaceAll(" ", "").trim();
        if (value.length() > 0) {
            String[] items = value.split(",");
            for (int i = 0; i < items.length; ++i) {
                result.add(items[i]);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            GenericObjectEditor ce = new GenericObjectEditor(true);
            ce.setClassType(Classifier.class);
            Object initial = new ZeroR();
            if (args.length > 0) {
                ce.setClassType(Class.forName(args[0]));
                if (args.length > 1) {
                    initial = Class.forName(args[1]).newInstance();
                    ce.setValue(initial);
                } else {
                    ce.setDefaultValue();
                }
            } else {
                ce.setValue(initial);
            }
            PropertyDialog pd = new PropertyDialog((Frame)null, (PropertyEditor)ce, 100, 100);
            pd.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
            pd.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.determineClasses();
    }

    public class GOEPanel
    extends JPanel {
        static final long serialVersionUID = 3656028520876011335L;
        protected PropertySheetPanel m_ChildPropertySheet;
        protected JLabel m_ClassNameLabel;
        protected JButton m_OpenBut;
        protected JButton m_SaveBut;
        protected JButton m_okBut;
        protected JButton m_cancelBut;
        protected JFileChooser m_FileChooser;

        public GOEPanel() {
            GenericObjectEditor.this.m_Backup = this.copyObject(GenericObjectEditor.this.m_Object);
            this.m_ClassNameLabel = new JLabel("None");
            this.m_ClassNameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_ChildPropertySheet = new PropertySheetPanel();
            this.m_ChildPropertySheet.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            this.m_OpenBut = new JButton("Open...");
            this.m_OpenBut.setToolTipText("Load a configured object");
            this.m_OpenBut.setEnabled(true);
            this.m_OpenBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.m_SaveBut = new JButton("Save...");
            this.m_SaveBut.setToolTipText("Save the current configured object");
            this.m_SaveBut.setEnabled(true);
            this.m_SaveBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.m_okBut = new JButton("OK");
            this.m_okBut.setEnabled(true);
            this.m_okBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.m_cancelBut = new JButton("Cancel");
            this.m_cancelBut.setEnabled(true);
            this.m_cancelBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.setLayout(new BorderLayout());
            if (GenericObjectEditor.this.m_canChangeClassInDialog) {
                JButton chooseButton = GenericObjectEditor.this.createChooseClassButton();
                JPanel top = new JPanel();
                top.setLayout(new BorderLayout());
                top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                top.add((Component)chooseButton, "West");
                top.add((Component)this.m_ClassNameLabel, "Center");
                this.add((Component)top, "North");
            } else {
                this.add((Component)this.m_ClassNameLabel, "North");
            }
            this.add((Component)this.m_ChildPropertySheet, "Center");
            JPanel okcButs = new JPanel();
            okcButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            okcButs.setLayout(new GridLayout(1, 4, 5, 5));
            okcButs.add(this.m_OpenBut);
            okcButs.add(this.m_SaveBut);
            okcButs.add(this.m_okBut);
            okcButs.add(this.m_cancelBut);
            this.add((Component)okcButs, "South");
            if (GenericObjectEditor.this.m_ClassType != null) {
                GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                if (GenericObjectEditor.this.m_Object != null) {
                    GenericObjectEditor.this.updateObjectNames();
                    this.updateChildPropertySheet();
                }
            }
        }

        protected void setCancelButton(boolean flag) {
            if (this.m_cancelBut != null) {
                this.m_cancelBut.setEnabled(flag);
            }
        }

        protected Object openObject() {
            int returnVal;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((returnVal = this.m_FileChooser.showOpenDialog(this)) == 0) {
                File selected = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(selected)));
                    Object obj = oi.readObject();
                    oi.close();
                    if (!GenericObjectEditor.this.m_ClassType.isAssignableFrom(obj.getClass())) {
                        throw new Exception("Object not of type: " + GenericObjectEditor.this.m_ClassType.getName());
                    }
                    return obj;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Couldn't read object: " + selected.getName() + "\n" + ex.getMessage(), "Open object file", 0);
                }
            }
            return null;
        }

        protected void saveObject(Object object) {
            int returnVal;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((returnVal = this.m_FileChooser.showSaveDialog(this)) == 0) {
                File sFile = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
                    oo.writeObject(object);
                    oo.close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage(), "Save object", 0);
                }
            }
        }

        protected void createFileChooser() {
            this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            this.m_FileChooser.setFileSelectionMode(0);
        }

        protected Object copyObject(Object source) {
            Object result = null;
            try {
                result = GenericObjectEditor.makeCopy(source);
                this.setCancelButton(true);
            }
            catch (Exception ex) {
                this.setCancelButton(false);
                System.err.println("GenericObjectEditor: Problem making backup object");
                System.err.println(ex);
            }
            return result;
        }

        public void setOkButtonText(String newLabel) {
            this.m_okBut.setText(newLabel);
        }

        public void addOkListener(ActionListener a) {
            this.m_okBut.addActionListener(a);
        }

        public void addCancelListener(ActionListener a) {
            this.m_cancelBut.addActionListener(a);
        }

        public void removeOkListener(ActionListener a) {
            this.m_okBut.removeActionListener(a);
        }

        public void removeCancelListener(ActionListener a) {
            this.m_cancelBut.removeActionListener(a);
        }

        public void updateChildPropertySheet() {
            String className = "None";
            if (GenericObjectEditor.this.m_Object != null) {
                className = GenericObjectEditor.this.m_Object.getClass().getName();
            }
            this.m_ClassNameLabel.setText(className);
            this.m_ChildPropertySheet.setTarget(GenericObjectEditor.this.m_Object);
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
                ((Window)this.getTopLevelAncestor()).pack();
            }
        }
    }
}

