% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtypes2loci.R
\name{gtypes2loci}
\alias{gtypes2loci}
\alias{loci2gtypes}
\title{Convert Between \code{gtypes} And \code{loci} objects.}
\usage{
gtypes2loci(x)

loci2gtypes(x, description = NULL)
}
\arguments{
\item{x}{a \linkS4class{gtypes} or \code{loci} formatted object.}

\item{description}{a label for the \code{gtypes} object (optional).}
}
\description{
Convert a \code{gtypes} object to a \code{\link[pegas]{loci}} object.
}
\examples{
data(msats.g)

# Convert to loci
lc <- gtypes2loci(msats.g)
lc

# Convert to gtypes
gt <- loci2gtypes(lc)
gt 

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\link{initialize.gtypes}, \link{df2gtypes}, 
  \link{sequence2gtypes}, \link{as.data.frame.gtypes}, 
  \link{gtypes2genind}
}

