% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{a2ld}
\alias{a2ld}
\title{3D Array to List of Data-Frames}
\usage{
a2ld(a, along = 3L, stringsAsFactors = FALSE, check = TRUE)
}
\arguments{
\item{a}{3D array.}

\item{along}{integer vector of length 1 specifying the dimension to slice the array
along. This dimension is converted to the list dimension. 1 = rows; 2 = columns;
3 = layers.}

\item{stringsAsFactors}{logical vector of length 1 specifying whether character
vectors should be converted to factors. Note, that if the array is character
and \code{stringsAsFactors} = TRUE, then all columns in the returned list of
data.frames will be factors.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{a} is a 3D array.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
list of data.frames - all with the same dimensions.
}
\description{
\code{a2ld} converts a 3D array to a list of data.frames. This is a simple call
to \code{a2lm} followed by \code{m2d}. The default is to convert the third
dimension to the list dimension.
}
\examples{
a2ld(HairEyeColor)
a2ld(HairEyeColor, along = 1)
try_expr(a2ld(mtcars)) # error b/c not a 3D array
}
