% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_grids.R
\name{make_grids}
\alias{make_grids}
\title{Make square grids}
\usage{
make_grids(poly, size = 250,
show_output = FALSE, interactive = FALSE)
}
\arguments{
\item{poly}{(as \code{spatialPolygons},
\code{spatialPolygonDataFrames}, or
\verb{simple features}). A polygon object over
which square grids are to be created.}

\item{size}{Size of square grids to be
created. For example, the input \code{size}
for a 250 by 250 square grids is \code{250}.}

\item{show_output}{(logical) Display the output.
Default: \code{FALSE}}

\item{interactive}{(logical) to show
interactive map of the grids generated.
Default: \code{FALSE}.}
}
\value{
Returns a "SpatialPolygonsDataFrames" object
representing a system of square grids covering
the polygon area.
}
\description{
Generates a system of square grids
over an area (boundary shapefile).
}
\details{
Generates a square grid system in a shapefile
format (in the same \code{crs} as the input \code{poly}).
If \code{interactive} argument is \code{TRUE}, an interactive
map is shown from which the centroid coordinates
of any grid can be displayed by hovering the mouse
over the grid. If internet connection is
available on the PC, a basemap (OpenStreetmap) is
added to help identify places.
}
\examples{
#load boundary of Camden
load(file = system.file("extdata", "camden.rda",
package="stppSim"))
boundary = camden$boundary
make_grids(poly=boundary, size = 250,
show_output = FALSE, interactive = FALSE)
}
