% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Data pre-processing for analysis with stochastic process model methodology.}
\usage{
prepare_data(x, col.id = NULL, col.status = NULL, col.age = NULL,
  col.age.event = NULL, covariates = NULL, interval = 1, impute = TRUE,
  verbose = FALSE)
}
\arguments{
\item{x}{A path to the file with table of follow-up oservations (longitudinal table). 
File formats: csv, sas7bdat}

\item{col.id}{A name of column containing subject ID. 
This ID should be the same in both x (longitudinal) and y (vital statistics) tables.
None: if col.id not provided, the first column of the x and 
first column of the y will be used by default.}

\item{col.status}{A name of the column containing status variable 
(0/1, which is an indicator of death/censoring). 
Note: if not provided - then the column #2 from the y (vital statistics) dataset will be used.}

\item{col.age}{A name of age column (also called 't1'). 
This column represents a time (age) of measurement.
If not provided then the 3rd column from the longitudinal dataset (x) will be used.}

\item{col.age.event}{A name of 'event' column.
The event column indicates a time when the even occured (e.g. system failure).
Note: if not provided then the 3rd column from the y (vital statistics) dataset will be used.}

\item{covariates}{A list of covariates (physiological variables). 
If covariates not provided, then all columns from longitudinal table having index > 3 will be used as covariates.}

\item{interval}{A number of breaks between observations for data for discrete model. 
This interval must be numeric (integer).
Default = 1 unit of time.}

\item{impute}{Multiple imputation ndicator. If TRUE then missing observations will be imputed with multiple imputation.
Default = TRUE.}

\item{verbose}{A verbosing output indicator. Default=FALSE.}
}
\value{
A list of two elements: first element contains a preprocessed data for continuous model, with arbitrary intervals between observations  and 
second element contains a prepocessed data table for a discrete model (with constant intervals between observations).
}
\description{
Data pre-processing for analysis with stochastic process model methodology.
}
\examples{
\dontrun{ 
library(stpm) 
data <- prepare_data(x=system.file("extdata","longdat.csv",package="stpm"))
head(data[[1]])
head(data[[2]])
}
}
