% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_sample.R
\name{n_sample_length}
\alias{n_sample_length}
\title{Sample integer number from given continuous vector of line lengths and probabilities, with total n}
\usage{
n_sample_length(n, l_lengths, weights)
}
\arguments{
\item{n}{Sum of integer values returned}

\item{l_lengths}{Numeric vector of line lengths}

\item{weights}{Relative probabilities of samples on lines}
}
\description{
Sample integer number from given continuous vector of line lengths and probabilities, with total n
}
\examples{
n <- 10
l_lengths <- 1:5
weights <- 9:5
(res <- n_sample_length(n, l_lengths, weights))
sum(res)
n <- 100
l_lengths <- c(12, 22, 15, 14)
weights <- c(38, 10, 44, 34)
(res <- n_sample_length(n, l_lengths, weights))
sum(res)
# more examples:
n_sample_length(5, 1:5, c(0.1, 0.9, 0, 0, 0))
n_sample_length(5, 1:5, c(0.5, 0.3, 0.1, 0, 0))
l <- flowlines[2:6, ]
l_lengths <- line_length(l)
n <- n_sample_length(10, l_lengths, weights = l$All)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_match}()},
\code{\link{line_midpoint}()},
\code{\link{line_sample}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()},
\code{\link{toptailgs}()},
\code{\link{update_line_geometry}()}
}
\concept{lines}
