% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{geo_toptail}
\alias{geo_toptail}
\alias{toptail}
\title{Clip the first and last n metres of SpatialLines}
\usage{
geo_toptail(l, toptail_dist, ...)
}
\arguments{
\item{l}{A SpatialLines object}

\item{toptail_dist}{The distance (in metres) to top and tail the line by.
Can either be a single value or a vector of the same length as the
SpatialLines object.}

\item{...}{Arguments passed to rgeos::gBuffer()}
}
\description{
Takes lines and removes the start and end point, to a distance determined
by the user.
}
\details{
Note: \code{\link{toptailgs}} is around 10 times faster, but only works
on data with geographic CRS's due to its reliance on the geosphere
package.
}
\examples{
l = routes_fast[2:4,]
l_toptail <- geo_toptail(l, toptail_dist = 300)
plot(l)
plot(l_toptail, col = "red", add = TRUE, lwd = 3)
plot(cents, col = "blue", add = TRUE, pch = 15)
# Note the behaviour when the buffer size removes lines
r_toptail <- geo_toptail(l, toptail_dist = 900)
plot(r_toptail, lwd = 9, add = TRUE) # short route removed
geo_toptail(routes_fast_sf[2:4, ], 300)
}
