% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_funs.R
\name{od_aggregate}
\alias{od_aggregate}
\title{Aggregate OD data between polygon geometries}
\usage{
od_aggregate(flow, zones, aggzones, cols = FALSE, aggcols = FALSE,
  FUN = sum, prop_by_area = ifelse(identical(FUN, mean) == FALSE, TRUE,
  FALSE), digits = getOption("digits"))
}
\arguments{
\item{flow}{A data frame representing the flow between two points
or zones. The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link{cents}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link{flow}}.}

\item{zones}{A SpatialPolygonsDataFrame or SpatialPointsDataFrame
representing the original centroids or boundaries of the travel flow data.
Note that in the case of a SpatialPointsDataFrame, the entirety of the flow
will be allocated to the polygon in which the point is located rather than
being distributed by area.}

\item{aggzones}{A SpatialPolygonsDataFrame containing the new
boundaries to aggregate to.}

\item{cols}{A character vector containing the names of columns on which to
apply FUN. By default, all numeric columns are aggregated.}

\item{aggcols}{A character vector containing the names of columns in
aggzones to retain in the aggregated data.frame. By default,
only the first column is retained. These columns are renamed with a prefix
of "o_" and "d_".}

\item{FUN}{Function to use on aggregation. Default is sum.}

\item{prop_by_area}{Boolean value indicating if the values should be
proportionally adjusted based on area. Default is TRUE unless FUN = mean.}

\item{digits}{The number of digits to use when proportionally adjusting
values based on area. Default is the value of getOption("digits").}
}
\value{
data.frame containing the aggregated od flows.
}
\description{
Aggregate OD data between polygon geometries
}
\section{Details}{

Origin-destination ('OD') flow data is often provided
in the form of 1 line per flow with zone codes of origin and destination
centroids. This function aggregates OD flows between polygon geometries
allocating the original flows to larger zones based on area.
}
\examples{
data(flow)
data(zones)
zones@data$region <- 1
zones@data[c(2, 5), c('region')] <- 2
aggzones <- SpatialPolygonsDataFrame(rgeos::gUnaryUnion(
 zones,
 id = zones@data$region), data.frame(region=c(1, 2))
)
zones@data$region <- NULL
od_aggregate(flow, zones, aggzones)
# another example with more zones and plots
zones$quadrant = quadrant(zones, number_out = TRUE)
aggzones <- SpatialPolygonsDataFrame(
rgeos::gUnaryUnion(
 zones,
 id = zones@data$quadrant), data.frame(region = c(1:4))
)
od = od_aggregate(flow, zones, aggzones)
od_sp = od2line(flow, zones)
zones@data = cbind(1:nrow(zones), zones@data)
od_sp_agg = od2line(od, zones, aggzones)
# plot results
plot(aggzones, lwd = 5)
plot(zones, border = "red", add = TRUE)
plot(od_sp, add = TRUE, col = "yellow")
lwd = od_sp_agg$All / 50
plot(od_sp_agg, lwd = lwd, add = TRUE)
}

