% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcov.R
\name{stcov}
\alias{stcov}
\title{Create \code{stcov} objects and interpolate spatio-temporal covariates on a regular grid}
\usage{
stcov(
  x,
  interp = TRUE,
  nx = NULL,
  mult = 1,
  p = 81,
  names = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{A data.frame with four columns, containing the spatio-temporal coordinates
and the covariate values.}

\item{interp}{Logical value indicating whether to interpolate the covariate
on a regular grid. Default to \code{TRUE}.}

\item{nx}{Number of coordinates to generate for each dimention.
The default is \code{floor((mult * nrow(cov)) ^ (1/3))}.}

\item{mult}{The multiplicand of the number of points in the default for \code{nx}.}

\item{p}{Power of IDW distances.}

\item{names}{Factor string to name the covariate.}

\item{verbose}{Default to FALSE. If TRUE, the elapsed minutes are printed.}
}
\value{
A \code{stpm} object, to be imputed as list object in \code{stppm}.
}
\description{
This function interpolates the covariate values observed 
at some observed sites to a regular grid. The imput object
should be either a matrix or a dataframe with four columns:
\code{x}, \code{y}, \code{t}, and the covariate values, named as the
 covariate later called in the model formula (see \code{stppm}).
 The interpolation is performed through Inverse Distance Weighting (IDW).
 See the Details.
}
\details{
The function builds a regular grid with equispaced values along the three
coordinates and interpolates the covariate values at the new locations.
The interpolation at a point location \eqn{x_k} is performed
through the inverse-distance weighting smoothing procedure of the covariate 
values \eqn{Z(x_j)} at their sampling locations \eqn{j=1, \ldots, J}. 
In such a case, the smoothed value at location \eqn{x_k} is 
\deqn{Z(x_k) = \frac{\sum_j w_j Z(x_j)}{\sum_j w_j},}
where the weight \eqn{w_j} is the \eqn{j}-th element of the inverse \eqn{p}th powers
of distance,  
\deqn{\textbf{w}=\{w_j\}_{j=1}^J=\{\frac{1}{d(x_k-x_j)^p}\}_{j=1}^J,}
with \deqn{d(x_k-x_j) = ||x_k-x_j||} the Euclidean distance from \eqn{x_k}
 to \eqn{x_j}.
}
\examples{


set.seed(2)
df <- data.frame(runif(100), runif(100), runif(100), rpois(100, 15))

cov <- stcov(df, interp = FALSE)


}
\seealso{
\link{stppm}
}
\author{
Nicoletta D'Angelo
}
