% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localSTLKinhom.R
\name{localSTLKinhom}
\alias{localSTLKinhom}
\title{Local inhomogeneous Spatio-temporal K-functions on a linear network}
\usage{
localSTLKinhom(
  x,
  lambda = lambda,
  normalize = FALSE,
  r = NULL,
  t = NULL,
  nxy = 10
)
}
\arguments{
\item{x}{A realisation of a spatio-temporal point processes on a linear network in \code{stlp} format}

\item{lambda}{values of estimated intensity.}

\item{normalize}{normalization factor to be considered.}

\item{r}{values of argument r where K-function will be evaluated. optional.}

\item{t}{values of argument t where K-function will be evaluated. optional.}

\item{nxy}{pixel array dimensions. optional.}
}
\value{
A list of class \code{lista}.
The objects are of class \code{sumstlpp} (Moradi and Mateu, 2020).
}
\description{
The functions \code{localSTLKinhom} and \code{localSTLginhom} implement the
inhomogeneous LISTA functions proposed in D'Angelo et al. (2022).
}
\details{
The homogeneous K-function and pair correlation functions, in
D'Angelo et al. (2021), can be obtained easily with \code{localSTLKinhom} and
\code{localSTLginhom}, by imputing a lambda vector of constant intensity
values, the same for each point.
}
\examples{

set.seed(2)
df_net <- data.frame(x = runif(25, 0, 0.85), y = runif(25, 0, 0.85), t = runif(25))
stlp1 <- stp(df_net, L = chicagonet)
lambda <- rep(diff(range(stlp1$df$x)) * diff(range(stlp1$df$y))
 * diff(range(stlp1$df$t)) / spatstat.geom::volume(stlp1$L),
nrow(stlp1$df))

k <- localSTLKinhom(stlp1, lambda = lambda, normalize = TRUE)



}
\references{
D’Angelo, N., Adelfio, G., and Mateu, J. (2021). Assessing local differences between the spatio-temporal second-order structure of two point patterns occurring on the same linear network. Spatial Statistics, 45, 100534.

D’Angelo, N., Adelfio, G.,  and Mateu, J. (2022). Local inhomogeneous second-order characteristics for spatio-temporal point processes on linear networks. Stat Papers. https://doi.org/10.1007/s00362-022-01338-4
}
\seealso{
\link{localSTLginhom}, \link{STLKinhom}, \link{STLginhom}
}
\author{
Nicoletta D'Angelo
}
