% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STMfunctions.R
\name{calcscore}
\alias{calcscore}
\title{Calculate Score Words}
\usage{
calcscore(logbeta)
}
\arguments{
\item{logbeta}{a K by V matrix containing the log probabilities of seeing word v conditional on topic k}
}
\description{
A primarily internal function for calculating words according to the score metric.
We expect most users will use \code{\link{labelTopics}} instead.
}
\details{
Score is a metric which we include because it is used effectively in the 
\pkg{lda} package by Jonathan Chang. It is calculated as:
\deqn{\beta_{v, k} (\log \beta_{w,k} - 1 / K \sum_{k'} \log \beta_{v,k'})}
}
\references{
Jonathan Chang (2015). lda: Collapsed Gibbs Sampling Methods for Topic Models. R package version 1.4.2.
https://CRAN.R-project.org/package=lda
}
\seealso{
\code{\link{labelTopics}}
}
\keyword{internal}

