% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_dist.R
\name{normal_dist}
\alias{normal_dist}
\title{Make and annotate a normal distribution with \pkg{ggplot2}}
\usage{
normal_dist(curvecolor, fillcolor, fontfamily)
}
\arguments{
\item{curvecolor}{What color should the curve itself be. Any \pkg{ggplot2}-recognized format should do here.}

\item{fillcolor}{What color should the area underneath the curve be. Any \pkg{ggplot2}-recognized format should do here.}

\item{fontfamily}{Font family for labeling areas underneath the curve. OPTIONAL. You can omit this if you'd like.}
}
\value{
The function returns a fancy plot of a normal distribution annotated with areas underneath the hood. Note that
whatever color is supplied in \code{fillcolor} is automatically lightened for areas further from the center of the druve.
}
\description{
\code{normal_dist()} is a convenience function for making a plot of a normal distribution
with annotated areas underneath the normal curve.
}
\details{
The normal distribution is a standard normal distribution with a mean of 0 and a standard deviation of 1.
}
\examples{

library(stevemisc)
normal_dist("blue","red")
normal_dist("purple","orange")
}
