% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTransactions_Ledger.R
\name{getTransactions_Ledger}
\alias{getTransactions_Ledger}
\title{Get an overview of transactions on the Stellar ledger.}
\usage{
getTransactions_Ledger(ledger, cursor = NULL, limit = NULL, order = "asc",
  data.table = TRUE)
}
\arguments{
\item{ledger}{numeric - a ledger ID.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}
}
\value{
data.table (by default) or list
}
\description{
Returns all valid transactions on a specific ledger. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/transactions-for-ledger.html
}
\examples{
\donttest{getTransactions_Ledger(300000)}
}
