% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_anova_expressions.R
\name{expr_anova_parametric}
\alias{expr_anova_parametric}
\title{Making expression containing parametric ANOVA results}
\usage{
expr_anova_parametric(
  data,
  x,
  y,
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  effsize.type = "unbiased",
  partial = TRUE,
  var.equal = FALSE,
  sphericity.correction = TRUE,
  stat.title = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (equivalent to \code{"d"} for Cohen's \emph{d} for
\strong{t-test}; \code{"partial_eta"} for partial eta-squared for \strong{anova}) or
\code{"unbiased"} (equivalent to \code{"g"} Hedge's \emph{g} for \strong{t-test};
\code{"partial_omega"} for partial omega-squared for \strong{anova})).}

\item{partial}{If \code{TRUE}, return partial indices.}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{sphericity.correction}{Logical that decides whether to apply correction
to account for violation of sphericity in a repeated measures design ANOVA
(Default: \code{TRUE}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
The effect sizes and their confidence intervals are computed
using \code{effectsize::eta_squared} and \code{effectsize::omega_squared} functions.
}
\note{
For repeated measures designs (\code{paired = TRUE}), only partial
omega-squared and partial eta-squared are supported.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(statsExpressions)

# -------------------- between-subjects ------------------------------

# with defaults
statsExpressions::expr_anova_parametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  paired = FALSE,
  k = 3
)

# modifying the defaults
statsExpressions::expr_anova_parametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  paired = FALSE,
  effsize.type = "eta",
  partial = FALSE,
  var.equal = TRUE
)

# -------------------- repeated measures ------------------------------

statsExpressions::expr_anova_parametric(
  data = iris_long,
  x = condition,
  y = value,
  paired = TRUE,
  k = 4
)
}
}
