% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_t_onesample_expressions.R
\name{expr_t_onesample}
\alias{expr_t_onesample}
\title{Expression for one sample \emph{t}-test and its non-parametric and
robust equivalents}
\usage{
expr_t_onesample(
  data,
  x,
  type = "parametric",
  test.value = 0,
  k = 2L,
  conf.level = 0.95,
  conf.type = "norm",
  bf.prior = 0.707,
  robust.estimator = "onestep",
  effsize.type = "g",
  nboot = 100L,
  stat.title = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A numeric variable from the dataframe \code{data}.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{robust.estimator}{If \code{type = "robust"}, a robust estimator to be used
(\code{"onestep"} (Default), \code{"mom"}, or \code{"median"}). For more, see
\code{?WRS2::onesampb}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"d"} (for Cohen's \emph{d}) or \code{"g"} (for Hedge's \emph{g}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Expression containing results from a one-sample test. The exact test
and the effect size details contained will be dependent on the \code{type}
argument.
}
\description{
Expression for one sample \emph{t}-test and its non-parametric and
robust equivalents
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# ----------------------- parametric ---------------------------------------

statsExpressions::expr_t_onesample(
  data = ggplot2::msleep,
  x = brainwt,
  test.value = 0.275,
  type = "parametric"
)

# ----------------------- non-parametric -----------------------------------

statsExpressions::expr_t_onesample(
  data = ggplot2::msleep,
  x = brainwt,
  test.value = 0.275,
  type = "nonparametric"
)

# ----------------------- robust --------------------------------------------

statsExpressions::expr_t_onesample(
  data = ggplot2::msleep,
  x = brainwt,
  test.value = 0.275,
  type = "robust"
)

# ----------------------- Bayes Factor -----------------------------------

statsExpressions::expr_t_onesample(
  data = ggplot2::msleep,
  x = brainwt,
  test.value = 0.275,
  type = "bayes",
  bf.prior = 0.8
)
}
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
