% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_functions.R
\name{retrieve_tables}
\alias{retrieve_tables}
\title{Retrieves an overview of the tables from Statistics Denmark}
\usage{
retrieve_tables()
}
\value{
a tibble
}
\description{
The function retrieves a data frame with all the available tables from the
Statistics Denmark API.
}
\details{
\describe{
  \item{id}{The id of the table. This is used when calling specific tables
      later with \link{retrieve_metadata} or \link{retrieve_data}.}
  \item{text}{A description of what the data in the table is about.}
  \item{unit}{What unit the data is in.}
  \item{updated}{When the table was last updated}
  \item{firstPeriod}{The first period in the data, ie how far back the data goes.}
  \item{latestPeriod}{The latest period in the data.}
  \item{active}{If the table is still being updated}
  \item{variables}{A list of the variables in the tables.}
}
}
\examples{
tables <- statsDK::retrieve_tables()
dplyr::glimpse(tables)
}
