% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.ratio.prop2}
\alias{ci.ratio.prop2}
\title{Confidence interval for a 2-group proportion ratio}
\usage{
ci.ratio.prop2(alpha, f1, f2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{number of participants in group 1 who have the attribute}

\item{f2}{number of participants in group 2 who have the attribute}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion ratio
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes an adjusted Wald confidence interval for a population proportion
ratio in a 2-group design.
}
\examples{
ci.ratio.prop2(.05, 35, 21, 150, 150)

# Should return:
# Estimate       LL       UL
# 1.666667 1.017253 2.705025


}
\references{
\insertRef{Price2008}{statpsych}
}
