% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cor2}
\alias{ci.cor2}
\title{Confidence interval for a 2-group Pearson correlation difference}
\usage{
ci.cor2(alpha, cor1, cor2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{sample Pearson correlation in group 1}

\item{cor2}{sample Pearson correlation in group 2}

\item{n1}{sample size in group 1}

\item{n2}{sample size in group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated correlation difference
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a difference in population Pearson
correlations in a 2-group design.
}
\examples{
ci.cor2(.05, .886, .802, 200, 200)

# Should return:
#      Estimate         LL        UL
# [1,]    0.084 0.02795506 0.1457103
 

}
\references{
\insertRef{Zou2007}{statpsych}
}
