% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{unused_dots_warning}
\alias{unused_dots_warning}
\title{An error handler for \code{\link[rlang:check_dots_used]{rlang::check_dots_used()}} that issues a
warning that only lists argument names.}
\usage{
unused_dots_warning(e)
}
\arguments{
\item{e}{a \link{condition} object, typically not passed by
the end-user; see example below.}
}
\description{
This handler parses the error message produced by
\code{\link[rlang:check_dots_used]{rlang::check_dots_used()}}, extracting the names of the unused
arguments, and formats them into a more gentle warning message. It
relies on \CRANpkg{rlang} maintaining its current format.
}
\examples{

\dontshow{
o <- options(warn=1, useFancyQuotes=FALSE)
}

g <- function(b=NULL, ...){
  invisible(force(b))
}

f <- function(...){
  rlang::check_dots_used(error = unused_dots_warning)
  g(...)
}

f() # OK
f(b=2) # OK
f(a=1, b=2, c=3) # Warning about a and c but not about b

\dontshow{
# Test:
stopifnot(grepl("Argument(s) 'a' and 'c' were not recognized or used. Did you mistype an argument name?", tryCatch(f(a=1, b=2, c=3), warning = function(e) e$message), fixed=TRUE))
options(o)
}
}
