% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runme.R
\name{rmd2html}
\alias{rmd2html}
\title{Convert an Rmd file into an HTML file}
\usage{
rmd2html(
  fn = NULL,
  wd = NULL,
  ...,
  verbose = FALSE,
  purl = TRUE,
  tangle = purl,
  backup = TRUE
)
}
\arguments{
\item{fn}{One or more filenames ending in "*.Rmd".}

\item{wd}{A working directory name of the Rmd file. If not
specified, then the current working directory from R will be
used.}

\item{...}{Arguments that will be passed to \code{rmarkdown::render} and
\code{rmarkdown::html_document}. We usually have customizations
via parameters \code{css} and \code{template},
but many other parameters can be specified to change arguments for
\code{rmarkdown::render} and \code{rmarkdown::html_documents}.
These possible arguments for \code{html_document}: \code{c("toc",
"toc_depth", "toc_float", "number_sections", "section_divs",
"fig_width", "fig_height", "fig_retina", "fig_caption", "dev",
"df_print", "code_folding", "code_download", "smart",
"self_contained", "theme", "highlight", "mathjax", "template",
"extra_dependencies", "css", "includes", "keep_md", "lib_dir",
"md_extensions", "pandoc_args")}. These arguments intended for
\code{render()} are allowed: \code{c("output_file", "output_dir",
"output_options", "intermediates_dir", "knit_root_dir",
"runtime", "clean", "params", "knit_meta", "envir",
"run_pandoc", "quiet", "encoding")}.}

\item{verbose}{The opposite of render(quiet = TRUE). Shows compile
commentary and pandoc command. Can be informative!}

\item{purl}{Default TRUE, synonym for tangle. Set either one, or
set both same, result is same.}

\item{tangle}{Default TRUE, synonym for purl}

\item{backup}{Default TRUE. Will create backup copies of pdf, R, Rnw
files before replacing them. Uses \code{kutils::file.backup}}
}
\value{
A vector of output file names
}
\description{
This is a very simple wrapper around the rmarkdown::render function.
It makes sure that the style sheet we want to use is applied to the data.
}
\details{
Running this will be the same as running the rmd2html.sh script
within the directory.
}
\examples{
\donttest{
tdir <- tempdir()
doctype <- "rmd2html-guide"
dirout <- initWriteup(doctype, dir = file.path(tdir, doctype))
list.files(dirout)

result <- try(rmd2html("skeleton.Rmd", wd = dirout))
if(inherits(result, "try-error")){
    MESSG <- paste("Compiling the markdown file failed, perhaps",
                  "your version of pandoc is not found")
    print(MESSG)
} else {
    ## Check the result file:
    MESSG <- paste("Check the directory", dirout, "for results.")
    print(MESSG)
    list.files(dirout)
    if(interactive() && file.exists(file.path(dirout, "skeleton.html"))) {
        browseURL(file.path(dirout, "skeleton.html"))
    }
}
unlink(dirout)
}
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
