% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFitMod.R
\name{summary.fitMod}
\alias{summary.fitMod}
\title{Summary function for fitMod objects}
\usage{
\method{summary}{fitMod}(object, ...)
}
\arguments{
\item{object}{An object of class fitMod.}

\item{...}{Ignored.}
}
\value{
No return value, a summary is printed.
}
\description{
Function for creating a short summary of the contents of a TP object. The
summary consists of the name of the experiment, the number of time points,
the engine used to fit the models and, in case spatial models where fitted
using asreml, the selected spatial model.
}
\examples{
\donttest{
## Using the first example dataset (PhenovatorDat1):
## Create an object of class TP.
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))

## Fit a SpATS model on few time points:
modPhenoSp <- fitModels(TP = phenoTP,
                        trait = "EffpsII",
                        timePoints = c(1, 6, 36))

## Create a summary.
summary(modPhenoSp)
}

}
\seealso{
Other functions for spatial modeling: 
\code{\link{fitModels}()},
\code{\link{getCorrected}()},
\code{\link{getEffDims}()},
\code{\link{getGenoPred}()},
\code{\link{getHerit}()},
\code{\link{getVar}()},
\code{\link{plot.fitMod}()}
}
\concept{functions for spatial modeling}
