/*
 * Decompiled with CFR 0.152.
 */
package phase;

import ints.IntArray;
import ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import phase.Ibs2Markers;
import phase.SampleSeg;
import vcf.GT;

public final class Ibs2Sets {
    private static final float MAX_MISS_STEP_FREQ = 0.1f;
    private final int nTargSamples;
    private final int nMarkersM1;
    private final IntArray windowStarts;
    private final int[][][] ibs2Sets;

    public Ibs2Sets(GT gT, Ibs2Markers ibs2Markers) {
        if (gT.nMarkers() != ibs2Markers.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(ibs2Markers.nMarkers()));
        }
        this.nMarkersM1 = gT.nMarkers() - 1;
        this.nTargSamples = gT.nSamples();
        this.windowStarts = ibs2Markers.stepStarts();
        WrappedIbs2Sets[] wrappedIbs2SetsArray = (WrappedIbs2Sets[])IntStream.range(0, this.windowStarts.size()).parallel().mapToObj(n -> Ibs2Sets.ibs2Sets(gT, ibs2Markers, this.windowStarts, n)).toArray(WrappedIbs2Sets[]::new);
        this.ibs2Sets = (int[][][])Arrays.stream(wrappedIbs2SetsArray).map(wrappedIbs2Sets -> ((WrappedIbs2Sets)wrappedIbs2Sets).ibsSets).toArray(n -> new int[n][][]);
    }

    private static WrappedIbs2Sets ibs2Sets(GT gT, Ibs2Markers ibs2Markers, IntArray intArray, int n) {
        int n2 = n + 1;
        int n3 = intArray.get(n);
        int n4 = n2 < intArray.size() ? intArray.get(n2) : gT.nMarkers();
        int[] nArray = ibs2Markers.markers(n3, n4);
        List<SampClust> list = new ArrayList<SampClust>(1);
        list.add(Ibs2Sets.initCluster(gT, nArray));
        int[] nArray2 = nArray;
        int n5 = nArray2.length;
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7 = n6 = nArray2[i];
            list = list.stream().flatMap(sampClust -> Ibs2Sets.partition(gT, sampClust, n7)).collect(Collectors.toCollection(ArrayList::new));
        }
        return Ibs2Sets.results(list, gT.nSamples());
    }

    private static SampClust initCluster(GT gT, int[] nArray) {
        int n = gT.nSamples();
        int[] nArray2 = new int[n];
        for (int n3 : nArray) {
            for (int i = 0; i < n; ++i) {
                if (gT.allele1(n3, i) != -1 && gT.allele2(n3, i) != -1) continue;
                int n4 = i;
                nArray2[n4] = nArray2[n4] + 1;
            }
        }
        int n5 = (int)Math.floor(0.1f * (float)nArray.length);
        int[] nArray3 = IntStream.range(0, n).filter(n2 -> nArray2[n2] <= n5).toArray();
        int n6 = 1;
        return new SampClust(nArray3, n6 != 0);
    }

    private static Stream<SampClust> partition(GT gT, SampClust sampClust, int n2) {
        int n3 = gT.marker(n2).nAlleles();
        IntList[] intListArray = new IntList[n3 * (n3 + 1) >> 1];
        boolean[] blArray = Ibs2Sets.isHom(sampClust.isHomozygous, n3);
        IntList intList = new IntList(32);
        for (int n4 : sampClust.samples) {
            int n5;
            int n6 = Ibs2Sets.getGT(n2, n4, gT);
            if (n6 < 0) {
                intList.add(n4);
                for (n5 = 0; n5 < intListArray.length; ++n5) {
                    if (intListArray[n5] == null) continue;
                    intListArray[n5].add(n4);
                }
                continue;
            }
            if (intListArray[n6] == null) {
                intListArray[n6] = new IntList();
                int n7 = intList.size();
                for (n5 = 0; n5 < n7; ++n5) {
                    intListArray[n6].add(intList.get(n5));
                }
            }
            intListArray[n6].add(n4);
        }
        return IntStream.range(0, intListArray.length).filter(n -> intListArray[n] != null && intListArray[n].size() > 1).mapToObj(n -> new SampClust(intListArray[n].toArray(), blArray[n]));
    }

    private static int getGT(int n, int n2, GT gT) {
        int n3 = gT.allele1(n, n2);
        int n4 = gT.allele2(n, n2);
        if (n3 < 0 || n4 < 0) {
            return -1;
        }
        return n3 <= n4 ? (n4 * (n4 + 1) >> 1) + n3 : (n3 * (n3 + 1) >> 1) + n4;
    }

    private static boolean[] isHom(boolean bl, int n) {
        boolean[] blArray = new boolean[n * (n + 1) >> 1];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                blArray[(i * (i + 1) >> 1) + i] = true;
            }
        }
        return blArray;
    }

    private static WrappedIbs2Sets results(List<SampClust> list, int n2) {
        int[] nArray = new int[]{};
        int[][] nArray2 = (int[][])IntStream.range(0, n2).mapToObj(n -> nArray).toArray(n -> new int[n][]);
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            SampClust sampClust = list.get(i);
            if (sampClust.isHomozygous) continue;
            int[] nArray3 = sampClust.samples;
            assert (nArray3.length > 1);
            for (int n4 : nArray3) {
                if (nArray2[n4] == nArray) {
                    nArray2[n4] = nArray3;
                    continue;
                }
                IntStream intStream = Arrays.stream(nArray2[n4]);
                IntStream intStream2 = Arrays.stream(nArray3);
                nArray2[n4] = IntStream.concat(intStream, intStream2).sorted().distinct().toArray();
            }
        }
        return new WrappedIbs2Sets(nArray2);
    }

    public int nTargSamples() {
        return this.nTargSamples;
    }

    public SampleSeg[] segList(int n) {
        ArrayList<SampleSeg> arrayList = new ArrayList<SampleSeg>();
        for (int i = 0; i < this.ibs2Sets.length; ++i) {
            int[] nArray = this.ibs2Sets[i][n];
            if (nArray.length <= 0) continue;
            int n2 = i + 1;
            int n3 = this.windowStarts.get(i);
            int n4 = n2 < this.windowStarts.size() ? this.windowStarts.get(n2) - 1 : this.nMarkersM1;
            for (int n5 : nArray) {
                if (n5 == n) continue;
                arrayList.add(new SampleSeg(n5, n3, n4));
            }
        }
        return arrayList.toArray(new SampleSeg[0]);
    }

    private static class WrappedIbs2Sets {
        private final int[][] ibsSets;

        private WrappedIbs2Sets(int[][] nArray) {
            this.ibsSets = nArray;
        }
    }

    private static class SampClust {
        private final int[] samples;
        private final boolean isHomozygous;

        private SampClust(int[] nArray, boolean bl) {
            this.samples = nArray;
            this.isHomozygous = bl;
        }

        private SampClust(int n) {
            this.samples = IntStream.range(0, n).toArray();
            this.isHomozygous = true;
        }
    }
}

