% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_as_tibble_list.R
\name{star_schema_as_tibble_list}
\alias{star_schema_as_tibble_list}
\alias{star_schema_as_tibble_list.star_schema}
\title{Export a star schema as a \code{tibble} list}
\usage{
star_schema_as_tibble_list(st, include_role_playing = FALSE)

\method{star_schema_as_tibble_list}{star_schema}(st, include_role_playing = FALSE)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{include_role_playing}{A boolean.}
}
\value{
A list of \code{tibble} objects.
}
\description{
Once we have refined the format or content of facts and dimensions, we can
obtain a \code{tibble} list with them. Role playing dimensions can be optionally
included.
}
\examples{
library(tidyr)

tl <- st_mrs_age \%>\%
  star_schema_as_tibble_list()

tl <- st_mrs_age \%>\%
  star_schema_as_tibble_list(include_role_playing = TRUE)

}
\seealso{


Other results export functions: 
\code{\link{constellation_as_multistar}()},
\code{\link{constellation_as_tibble_list}()},
\code{\link{multistar_as_flat_table}()},
\code{\link{star_schema_as_flat_table}()},
\code{\link{star_schema_as_multistar}()}
}
\concept{results export functions}
