% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{st_mrs_age_w11}
\alias{st_mrs_age_w11}
\title{Star Schema for Mortality Reporting System by Age for Week 11}
\format{
A \code{star_schema} object.
}
\usage{
st_mrs_age_w11
}
\description{
Star Schema for the Mortality Reporting System considering the age
classification data, for week 11 of 1962. It also includes some isolated data
from previous weeks that is supposed to be corrections for data errors.
}
\examples{
# Defined by:

library(tidyr)

st_mrs_age_w11 <- star_schema(mrs_age_w11, dm_mrs_age) \%>\%
  role_playing_dimension(
    dim_names = c("when", "when_available"),
    name = "When Common",
    attributes = c("date", "week", "year")
  ) \%>\%
  snake_case() \%>\%
  character_dimensions(NA_replacement_value = "Unknown",
                       length_integers = list(week = 2))

}
\keyword{datasets}
