% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{st_mrs_age}
\alias{st_mrs_age}
\title{Star Schema for Mortality Reporting System by Age}
\format{
A \code{star_schema} object.
}
\usage{
st_mrs_age
}
\description{
Star Schema for the Mortality Reporting System considering the age
classification.
}
\examples{
# Defined by:

library(tidyr)

st_mrs_age <- star_schema(mrs_age, dm_mrs_age) \%>\%
  role_playing_dimension(
    dim_names = c("when", "when_available"),
    name = "When Common",
    attributes = c("date", "week", "year")
  ) \%>\%
  snake_case() \%>\%
  character_dimensions(NA_replacement_value = "Unknown",
                       length_integers = list(week = 2))

}
\keyword{datasets}
