/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.PdfBookmark;
import com.gitlab.pdftk_java.data_import;
import com.gitlab.pdftk_java.report;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import pdftk.com.lowagie.text.pdf.PRIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfArray;
import pdftk.com.lowagie.text.pdf.PdfDestination;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfString;
import pdftk.com.lowagie.text.pdf.PdfWriter;

class bookmarks {
    bookmarks() {
    }

    static int GetPageNumber(PdfDictionary dict_p, PdfReader reader_p, HashMap<PdfDictionary, Integer> cache) {
        Integer it = cache.get(dict_p);
        if (it != null) {
            return it;
        }
        int ret_val = 0;
        if (dict_p != null && dict_p.contains(PdfName.PARENT)) {
            PdfObject parent_po = PdfReader.getPdfObject(dict_p.get(PdfName.PARENT));
            if (parent_po != null && parent_po.isDictionary()) {
                PdfDictionary parent_p = (PdfDictionary)parent_po;
                int sum_pages = bookmarks.GetPageNumber(parent_p, reader_p, cache);
                PdfObject parent_kids_p = PdfReader.getPdfObject(parent_p.get(PdfName.KIDS));
                if (parent_kids_p != null && parent_kids_p.isArray()) {
                    ArrayList kids_p = ((PdfArray)parent_kids_p).getArrayList();
                    if (kids_p != null) {
                        for (PdfObject kids_ii : kids_p) {
                            PdfObject kid_po = PdfReader.getPdfObject(kids_ii);
                            if (kid_po != null && kid_po.isDictionary()) {
                                PdfObject kid_type_p;
                                PdfDictionary kid_p = (PdfDictionary)kid_po;
                                if (kid_p == dict_p) {
                                    ret_val = sum_pages;
                                }
                                if ((kid_type_p = PdfReader.getPdfObject(kid_p.get(PdfName.TYPE))) != null && kid_type_p.isName()) {
                                    if (kid_type_p.equals(PdfName.PAGE)) {
                                        cache.put(kid_p, sum_pages);
                                        ++sum_pages;
                                        continue;
                                    }
                                    if (kid_type_p.equals(PdfName.PAGES)) {
                                        PdfObject count_p = PdfReader.getPdfObject(kid_p.get(PdfName.COUNT));
                                        if (count_p != null && count_p.isNumber()) {
                                            sum_pages += ((PdfNumber)count_p).intValue();
                                            continue;
                                        }
                                        System.err.println("pdftk Error in GetPageNumber(): invalid count;");
                                        continue;
                                    }
                                    System.err.println("pdftk Error in GetPageNumber(): unexpected kid type;");
                                    continue;
                                }
                                System.err.println("pdftk Error in GetPageNumber(): invalid kid_type_p;");
                                continue;
                            }
                            System.err.println("pdftk Error in GetPageNumber(): invalid kid_p;");
                        }
                    } else {
                        System.err.println("pdftk Error in GetPageNumber(): invalid kids_p;");
                    }
                } else {
                    System.err.println("pdftk Error in GetPageNumber(): invalid kids array;");
                }
            } else {
                System.err.println("pdftk Error in GetPageNumber(): invalid parent;");
            }
        } else {
            ret_val = 0;
            cache.put(dict_p, ret_val);
        }
        return ret_val;
    }

    static int ReadOutlines(ArrayList<PdfBookmark> bookmark_data, PdfDictionary outline_p, int level, PdfReader reader_p, boolean utf8_b) {
        int ret_val = 0;
        HashMap<PdfDictionary, Integer> cache = new HashMap<PdfDictionary, Integer>();
        while (outline_p != null) {
            PdfBookmark bookmark = new PdfBookmark();
            PdfObject title_p = PdfReader.getPdfObject(outline_p.get(PdfName.TITLE));
            if (title_p != null && title_p.isString()) {
                bookmark.m_title = report.OutputPdfString((PdfString)title_p, utf8_b);
            } else {
                ret_val = 1;
            }
            bookmark.m_level = level + 1;
            boolean fail_b = false;
            PdfObject destination_p = null;
            if (outline_p.contains(PdfName.DEST)) {
                destination_p = PdfReader.getPdfObject(outline_p.get(PdfName.DEST));
            } else if (outline_p.contains(PdfName.A)) {
                PdfObject action_po = PdfReader.getPdfObject(outline_p.get(PdfName.A));
                if (action_po != null && action_po.isDictionary()) {
                    PdfDictionary action_p = (PdfDictionary)action_po;
                    PdfObject s_p = PdfReader.getPdfObject(action_p.get(PdfName.S));
                    if (s_p != null && s_p.isName()) {
                        if (s_p.equals(PdfName.GOTO)) {
                            destination_p = PdfReader.getPdfObject(action_p.get(PdfName.D));
                        }
                    } else {
                        fail_b = true;
                    }
                } else {
                    fail_b = true;
                }
            } else {
                fail_b = true;
            }
            if (destination_p != null && destination_p.isArray()) {
                ArrayList array_list_p = ((PdfArray)destination_p).getArrayList();
                if (array_list_p != null && !array_list_p.isEmpty()) {
                    PdfObject page_p = PdfReader.getPdfObject((PdfObject)array_list_p.get(0));
                    if (page_p != null && page_p.isDictionary()) {
                        bookmark.m_page_num = bookmarks.GetPageNumber((PdfDictionary)page_p, reader_p, cache) + 1;
                    } else {
                        fail_b = true;
                    }
                } else {
                    fail_b = true;
                }
            } else {
                fail_b = true;
            }
            if (fail_b) {
                bookmark.m_page_num = 0;
            }
            if (0 < bookmark.m_level) {
                bookmark_data.add(bookmark);
            }
            if (outline_p.contains(PdfName.FIRST)) {
                PdfObject child_p = PdfReader.getPdfObject(outline_p.get(PdfName.FIRST));
                if (child_p != null && child_p.isDictionary()) {
                    ret_val += bookmarks.ReadOutlines(bookmark_data, (PdfDictionary)child_p, level + 1, reader_p, utf8_b);
                }
            }
            if (outline_p.contains(PdfName.NEXT)) {
                PdfObject sibling_p = PdfReader.getPdfObject(outline_p.get(PdfName.NEXT));
                if (sibling_p != null && sibling_p.isDictionary()) {
                    outline_p = (PdfDictionary)sibling_p;
                    continue;
                }
                outline_p = null;
                continue;
            }
            outline_p = null;
        }
        return ret_val;
    }

    static void RemoveBookmarks(PdfReader reader_p, PdfDictionary bookmark_p) {
        if (bookmark_p.contains(PdfName.FIRST)) {
            PdfDictionary first_p = (PdfDictionary)PdfReader.getPdfObject(bookmark_p.get(PdfName.FIRST));
            bookmarks.RemoveBookmarks(reader_p, first_p);
            bookmark_p.remove(PdfName.FIRST);
        }
        if (bookmark_p.contains(PdfName.NEXT)) {
            PdfDictionary next_p = (PdfDictionary)PdfReader.getPdfObject(bookmark_p.get(PdfName.NEXT));
            bookmarks.RemoveBookmarks(reader_p, next_p);
            bookmark_p.remove(PdfName.NEXT);
        }
        bookmark_p.remove(PdfName.PARENT);
        bookmark_p.remove(PdfName.PREV);
        bookmark_p.remove(PdfName.LAST);
    }

    static int BuildBookmarks(PdfReader reader_p, ListIterator<PdfBookmark> it, PdfDictionary parent_p, PRIndirectReference parent_ref_p, int parent_level, boolean utf8_b) {
        PRIndirectReference bookmark_ref_p;
        PdfDictionary bookmark_p;
        int num_bookmarks_total = 0;
        PdfDictionary bookmark_prev_p = null;
        PRIndirectReference bookmark_first_ref_p = null;
        PRIndirectReference bookmark_prev_ref_p = null;
        int num_bookmarks = 0;
        PdfBookmark it_content = it.next();
        it.previous();
        if (parent_level + 1 < it_content.m_level) {
            ++num_bookmarks;
            ++num_bookmarks_total;
            bookmark_p = new PdfDictionary();
            bookmark_first_ref_p = bookmark_ref_p = reader_p.getPRIndirectReference(bookmark_p);
            bookmark_p.put(PdfName.PARENT, parent_ref_p);
            PdfString title_p = new PdfString("");
            bookmark_p.put(PdfName.TITLE, title_p);
            bookmark_prev_p = bookmark_p;
            bookmark_prev_ref_p = bookmark_ref_p;
        }
        while (it.hasNext()) {
            it_content = it.next();
            it.previous();
            if (parent_level + 1 < it_content.m_level) {
                num_bookmarks_total += bookmarks.BuildBookmarks(reader_p, it, bookmark_prev_p, bookmark_prev_ref_p, parent_level + 1, utf8_b);
                it.previous();
            } else {
                if (it_content.m_level < parent_level + 1) break;
                ++num_bookmarks;
                ++num_bookmarks_total;
                bookmark_p = new PdfDictionary();
                bookmark_ref_p = reader_p.getPRIndirectReference(bookmark_p);
                if (bookmark_first_ref_p == null) {
                    bookmark_first_ref_p = bookmark_ref_p;
                }
                bookmark_p.put(PdfName.PARENT, parent_ref_p);
                if (bookmark_prev_ref_p != null) {
                    bookmark_p.put(PdfName.PREV, bookmark_prev_ref_p);
                    bookmark_prev_p.put(PdfName.NEXT, bookmark_ref_p);
                }
                if (utf8_b) {
                    bookmark_p.put(PdfName.TITLE, new PdfString(it_content.m_title));
                } else {
                    String jvs = data_import.XmlStringToJcharArray(it_content.m_title);
                    bookmark_p.put(PdfName.TITLE, new PdfString(jvs));
                }
                if (0 < it_content.m_page_num) {
                    PdfDestination dest_p = new PdfDestination(1);
                    PRIndirectReference page_ref_p = reader_p.getPageOrigRef(it_content.m_page_num);
                    if (page_ref_p != null) {
                        dest_p.addPage(page_ref_p);
                    }
                    bookmark_p.put(PdfName.DEST, dest_p);
                }
                bookmark_prev_p = bookmark_p;
                bookmark_prev_ref_p = bookmark_ref_p;
            }
            it.next();
        }
        if (bookmark_first_ref_p != null && bookmark_prev_ref_p != null) {
            parent_p.put(PdfName.FIRST, bookmark_first_ref_p);
            parent_p.put(PdfName.LAST, bookmark_prev_ref_p);
            if (parent_level == 0) {
                parent_p.put(PdfName.COUNT, new PdfNumber(num_bookmarks_total));
            } else {
                parent_p.put(PdfName.COUNT, new PdfNumber(num_bookmarks));
            }
        }
        return num_bookmarks_total;
    }

    static void BuildBookmarks(PdfWriter writer_p, ListIterator<PdfBookmark> it, PdfDictionary parent_p, PdfIndirectReference parent_ref_p, PdfDictionary after_child_p, PdfIndirectReference after_child_ref_p, int parent_level, int page_num_offset, int level_offset, boolean utf8_b, BuildBookmarksState state) throws IOException {
        PdfIndirectReference bookmark_ref_p;
        PdfDictionary bookmark_p;
        PdfDictionary bookmark_prev_p = after_child_p;
        PdfIndirectReference bookmark_prev_ref_p = after_child_ref_p;
        PdfIndirectReference bookmark_first_ref_p = null;
        int num_bookmarks = 0;
        PdfBookmark it_content = it.next();
        it.previous();
        if (parent_level + 1 < it_content.m_level) {
            ++num_bookmarks;
            ++state.num_bookmarks_total;
            bookmark_p = new PdfDictionary();
            bookmark_first_ref_p = bookmark_ref_p = writer_p.getPdfIndirectReference();
            bookmark_p.put(PdfName.PARENT, parent_ref_p);
            PdfString title_p = new PdfString("");
            bookmark_p.put(PdfName.TITLE, title_p);
            bookmark_prev_p = bookmark_p;
            bookmark_prev_ref_p = bookmark_ref_p;
        }
        while (it.hasNext()) {
            it_content = it.next();
            it.previous();
            if (parent_level + 1 < it_content.m_level) {
                bookmarks.BuildBookmarks(writer_p, it, bookmark_prev_p, bookmark_prev_ref_p, null, null, parent_level + 1, page_num_offset, level_offset, utf8_b, state);
                it.previous();
            } else {
                if (it_content.m_level < parent_level + 1) break;
                ++num_bookmarks;
                ++state.num_bookmarks_total;
                bookmark_p = new PdfDictionary();
                bookmark_ref_p = writer_p.getPdfIndirectReference();
                if (bookmark_first_ref_p == null) {
                    bookmark_first_ref_p = bookmark_ref_p;
                }
                bookmark_p.put(PdfName.PARENT, parent_ref_p);
                if (bookmark_prev_ref_p != null) {
                    bookmark_p.put(PdfName.PREV, bookmark_prev_ref_p);
                    bookmark_prev_p.put(PdfName.NEXT, bookmark_ref_p);
                }
                if (utf8_b) {
                    bookmark_p.put(PdfName.TITLE, new PdfString(it_content.m_title));
                } else {
                    String jvs = data_import.XmlStringToJcharArray(it_content.m_title);
                    bookmark_p.put(PdfName.TITLE, new PdfString(jvs));
                }
                if (0 < it_content.m_page_num) {
                    PdfDestination dest_p = new PdfDestination(1);
                    PdfIndirectReference page_ref_p = writer_p.getPageReference(it_content.m_page_num + page_num_offset);
                    if (page_ref_p != null) {
                        dest_p.addPage(page_ref_p);
                    }
                    bookmark_p.put(PdfName.DEST, dest_p);
                }
                if (bookmark_prev_p != null) {
                    writer_p.addToBody((PdfObject)bookmark_prev_p, bookmark_prev_ref_p);
                }
                bookmark_prev_p = bookmark_p;
                bookmark_prev_ref_p = bookmark_ref_p;
            }
            it.next();
        }
        if (bookmark_prev_p != null && after_child_p == null) {
            writer_p.addToBody((PdfObject)bookmark_prev_p, bookmark_prev_ref_p);
        }
        if (bookmark_first_ref_p != null && bookmark_prev_ref_p != null) {
            if (!parent_p.contains(PdfName.FIRST)) {
                parent_p.put(PdfName.FIRST, bookmark_first_ref_p);
            }
            parent_p.put(PdfName.LAST, bookmark_prev_ref_p);
            if (parent_level == 0) {
                parent_p.put(PdfName.COUNT, new PdfNumber(state.num_bookmarks_total));
            } else {
                parent_p.put(PdfName.COUNT, new PdfNumber(num_bookmarks));
            }
        }
        state.final_child_p = bookmark_prev_p;
        state.final_child_ref_p = bookmark_prev_ref_p;
    }

    static class BuildBookmarksState {
        PdfDictionary final_child_p;
        PdfIndirectReference final_child_ref_p;
        int num_bookmarks_total;

        BuildBookmarksState() {
        }
    }
}

