% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{bj.sevt}
\alias{bj.sevt}
\title{Backward joining of stages}
\usage{
bj.sevt(object = NULL, distance = kl, thr = 0.1, trace = 0, ...)
}
\arguments{
\item{object}{the staged event tree from where to start}

\item{distance}{the distance between probabilities to use}

\item{thr}{the threshold for joining stages}

\item{trace}{if >0 increasingly amount of info}

\item{...}{additional parameters to be passed to the distance function
is printed (via \code{message})}
}
\value{
The final staged event tree obtained.
}
\description{
Join stages from more complex to simpler models
using a distance and a threshold value
}
\details{
For each variable in the model stages are joined iteratively.
At each iteration the two stages with minimum distance are selected and
joined if their distance is less than \code{thr}.
}
\examples{
DD <- generate_xor_dataset(n = 5, N = 1000)
model <- bj.sevt(full(DD, lambda = 1), trace = 2)
summary(model)
}
